package eu.dnetlib.dli.resolver;

import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;

import org.springframework.beans.factory.annotation.Autowired;

import java.util.Arrays;

/**
 * Created by sandro on 9/26/16.
 */
public class NCBINResolver extends AbstractPIDResolver {

	private final static String baseUrl =
				"https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=nucleotide&id=%s";

//                "https://www.ncbi.nlm.nih.gov/sviewer/viewer.fcgi?db=nuccore&val=%s&page_size=5&fmt_mask=0&report=gbx&retmode=text&page=1&page_size=1";

	private final static String NCBI_NSPREFIX = "r3d100010778";

	@Autowired
	private NCBINParser NCBINParser;

	@Override
	public boolean canResolvePid(final String pidType) {
		return pidType != null && (pidType.toLowerCase().equals("protein") || pidType.toLowerCase().equals("ncbi-n") || pidType.toLowerCase().equals("ncbi-p")|| pidType.toLowerCase().equals("ncbi-wgs"));
	}

	@Override
	@Deprecated
    public DLIResolvedObject resolve(final String pid, final String pidType) {
		return null;
//		if ((pid == null))
//			return null;
//        final DLIResolvedObject record = NCBINParser.parseRecord(requestURL(String.format(baseUrl, pid)));
//        if (record != null) {
//			record.setPid(pid);
//			record.setPidType(pidType);
//			record.setCompletionStatus(CompletionStatus.complete.toString());
//            DLIObjectProvenance provenance = new DLIObjectProvenance();
//            DLIPIDResolver.setDatasourceProvenance(provenance, NCBI_NSPREFIX);
//            record.setDatasourceProvenance(Arrays.asList(provenance));
//		}
//		return record;
	}

	public NCBINParser getNCBINParser() {
		return NCBINParser;
	}

	public void setNCBINParser(final NCBINParser NCBINParser) {
		this.NCBINParser = NCBINParser;
	}
}
