package eu.dnetlib.dli.resolver;

import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * The Class RCBSResolver.
 *
 * @author sandro
 */
public class RCSBResolver extends AbstractPIDResolver {

	/**
	 * The Constant log.
	 */
	private static final Log log = LogFactory.getLog(RCSBResolver.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * The template url.
	 */
	private static String TEMPLATE_URL =
			"http://www.rcsb.org/pdb/rest/customReport?pdbids=%s&customReportColumns=structureTitle,structureAuthor,releaseDate&service=wsfile";

	/**
	 * The rcbs parser.
	 */
	@Autowired
	private RCSBParser rcsbParser;

	@Override
	protected boolean canResolvePid(final String pidType) {
		return pidType != null && pidType.toLowerCase().trim().equals("pdb");
	}

	@Override
    protected DLIResolvedObject resolve(final String pid, final String pidType) {
        String URL = String.format(TEMPLATE_URL, pid);
		return rcsbParser.parseRecord(requestURL(URL));
	}

}
