package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class FindDedupConfigurationJobNode extends SimpleJobNode {


    private String configName;

    @Autowired
    UniqueServiceLocator uniqueServiceLocator;

    private final static String query ="for $x in collection('/db/DRIVER/DedupConfigurationDSResources/DedupConfigurationDSResourceType') where $x//RESOURCE_IDENTIFIER/@value ='%s' return $x//DEDUPLICATION/text()";

    @Override
    protected String execute(Env env) throws Exception {


        if (StringUtils.isBlank(configName)) throw new IllegalArgumentException("missing configuration sequence");

        env.setAttribute("dconf", getProfile());
        return Arc.DEFAULT_ARC;
    }


    private String getProfile() throws Exception {
        ISLookUpService service = uniqueServiceLocator.getService(ISLookUpService.class);

        List<String> resourceProfile = service.quickSearchProfile(String.format(query,configName));


        if (resourceProfile.size()!= 1) throw new IllegalStateException("Query should return on result query:"+String.format(query,configName));

        return  compressArgument(resourceProfile.get(0));


    }

    private static String compressArgument(final String value)  throws Exception{
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(value.getBytes());
        gzip.close();
        return java.util.Base64.getEncoder().encodeToString(out.toByteArray());
    }

    public String getConfigName() {
        return configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }


}
