/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.collector.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIObjectRelation;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.antlr.stringtemplate.NoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrossRefIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(CrossRefIterator.class);
    private int current = 0;
    private int total = 0;
    private String nextCursor;
    private final StringTemplate resolverSerializer;
    private List<JsonElement> buffer = new ArrayList<JsonElement>();
    private String nextItem;

    public CrossRefIterator(StringTemplate resolverSerializer) {
        this.resolverSerializer = resolverSerializer;
        this.nextItem = this.calculateNextItem();
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public String next() {
        String tmp = this.nextItem;
        this.nextItem = this.calculateNextItem();
        ++this.current;
        return tmp;
    }

    private String calculateNextItem() {
        if (this.buffer.isEmpty() && !this.requestNextBuffer()) {
            return null;
        }
        if (this.buffer.isEmpty()) {
            return null;
        }
        JsonObject item = this.buffer.remove(0).getAsJsonObject();
        try {
            String t_type;
            DLIResolvedObject object = new DLIResolvedObject();
            String id = item.get("Source").getAsJsonObject().get("Identifier").getAsJsonObject().get("ID").getAsString();
            String id_type = item.get("Source").getAsJsonObject().get("Identifier").getAsJsonObject().get("IDScheme").getAsString();
            object.setPid(id);
            object.setPidType(id_type);
            JsonElement licenseURL = item.get("LicenseURL");
            String type = item.get("Source").getAsJsonObject().get("Type").getAsJsonObject().get("Name").isJsonNull() ? "unknownw" : item.get("Source").getAsJsonObject().get("Type").getAsJsonObject().get("Name").getAsString();
            object.setType(type.equals("literature") ? ObjectType.publication : ObjectType.dataset);
            String relType = item.get("RelationshipType").getAsJsonObject().get("Name").getAsString();
            object.setDatasourceProvenance(Collections.singletonList(new DLIObjectProvenance().setDatasource("Crossref").setDatasourceId("dli_________::crossref")));
            DLIObjectRelation relation = new DLIObjectRelation();
            relation.setRelationSemantics(relType);
            String t_id = item.get("Target").getAsJsonObject().get("Identifier").getAsJsonObject().get("ID").getAsString();
            String t_id_type = item.get("Target").getAsJsonObject().get("Identifier").getAsJsonObject().get("IDScheme").getAsString();
            String string = t_type = item.get("Target").getAsJsonObject().get("Type").getAsJsonObject().get("Name").isJsonNull() ? "unknown" : item.get("Target").getAsJsonObject().get("Type").getAsJsonObject().get("Name").getAsString();
            if (licenseURL != null && !licenseURL.isJsonNull()) {
                relation.setLicense(licenseURL.getAsString());
            }
            relation.setTargetPID(new PID(t_id, t_id_type));
            relation.setTargetType(t_type.equals("literature") ? ObjectType.publication : ObjectType.dataset);
            object.setRelations(Collections.singletonList(relation));
            relation.setCompletionStatus("incomplete");
            relation.setRelationProvenance(Collections.singletonList(new DLIObjectProvenance().setDatasource("Crossref").setDatasourceId("dli_________::crossref")));
            try {
                StringWriter writer = new StringWriter(16);
                NoIndentWriter out = new NoIndentWriter((Writer)writer);
                this.resolverSerializer.removeAttribute("object");
                this.resolverSerializer.setAttribute("object", (Object)object);
                this.resolverSerializer.write((StringTemplateWriter)out);
                String result = writer.toString();
                writer.close();
                return result;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable e) {
            System.out.println(item.toString());
            throw new RuntimeException(e);
        }
    }

    private boolean requestNextBuffer() {
        JsonElement jElement;
        String templateUrlWithCursor = "https://api.eventdata.crossref.org/v1/events/scholix?mailto=sandro.labruzzo@isti.cnr.it&rows=1000&cursor=%s";
        String templateUrl = "https://api.eventdata.crossref.org/v1/events/scholix?mailto=sandro.labruzzo@isti.cnr.it&rows=1000";
        String s = AbstractPIDResolver.requestURL((String)(this.nextCursor == null ? templateUrl : String.format(templateUrlWithCursor, this.nextCursor)), (int)30, (int)2);
        if (s != null && (jElement = new JsonParser().parse(s)).getAsJsonObject().has("message")) {
            JsonObject message = jElement.getAsJsonObject().get("message").getAsJsonObject();
            this.nextCursor = message.has("next-cursor") && !message.get("next-cursor").isJsonNull() ? message.get("next-cursor").getAsString() : null;
            this.total = message.get("total-results").getAsInt();
            JsonArray items = message.get("link-packages").getAsJsonArray();
            if (items == null || items.size() == 0) {
                return this.requestNextBuffer();
            }
            items.forEach(this.buffer::add);
            return this.nextCursor != null;
        }
        return false;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }
}

