/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.collector.plugin;

import eu.dnetlib.dli.collector.plugin.ScholixJSONParser;
import eu.dnetlib.dli.resolver.model.serializer.DLIResolverSerializer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ScholixIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(ScholixIterator.class);
    private final Iterator<Path> pathIterator;
    private Iterator<String> currentIterator;
    private String nextItem;
    private final DLIResolverSerializer serializer;
    private static final String template = "<record xmlns:oaf=\"http://namespace.dnet.eu/oaf\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">%s</record>";

    public ScholixIterator(DirectoryStream<Path> pathIterator, DLIResolverSerializer serializer) {
        this.pathIterator = pathIterator.iterator();
        this.serializer = serializer;
        this.nextItem = this.generateNextItem();
    }

    private String generateNextItem() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            this.getNextIterator();
            if (this.currentIterator != null && this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            return null;
        }
        return this.currentIterator.next();
    }

    private void getNextIterator() {
        if (this.pathIterator.hasNext()) {
            try {
                Path nextPath = this.pathIterator.next();
                log.debug((Object)("Request Next Iterator NextPath :" + nextPath.getFileName()));
                this.currentIterator = Files.lines(nextPath).map(ScholixJSONParser::parse).filter(Objects::nonNull).map(arg_0 -> ((DLIResolverSerializer)this.serializer).serializeToXML(arg_0)).map(it -> String.format(template, it)).iterator();
            }
            catch (Throwable e) {
                throw new RuntimeException("Error on generating next Iterator ", e);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public String next() {
        String tmp = this.nextItem;
        this.nextItem = this.generateNextItem();
        return tmp;
    }
}

