/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dli.resolver.DLIPIDResolver;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataciteResolver
extends AbstractPIDResolver {
    public static final String DATACITE_NS_PREFIX = "datacite____";
    private static final Log log = LogFactory.getLog(DataciteResolver.class);
    private static final String baseURL = "https://api.datacite.org/works/";

    private static String getStringValue(JsonObject root, String key, String defaultValue) {
        if (root.has(key) && !root.get(key).isJsonNull()) {
            return root.get(key).getAsString();
        }
        return defaultValue;
    }

    public static DLIResolvedObject parseResponse(String response) {
        if (response == null) {
            return null;
        }
        JsonElement jElement = new JsonParser().parse(response);
        JsonObject jobject = jElement.getAsJsonObject();
        if (jobject.has("data")) {
            DLIResolvedObject responseObj = new DLIResolvedObject();
            JsonObject root = jobject.getAsJsonObject("data").getAsJsonObject("attributes");
            String doi = root.get("doi").getAsString();
            responseObj.setPid(doi);
            responseObj.setPidType("doi");
            responseObj.setType(ObjectType.dataset);
            ArrayList authors = Lists.newArrayList();
            if (root.has("title") && root.get("title").isJsonArray()) {
                responseObj.setTitles(DnetStreamSupport.generateStreamFromIterator((Iterator)root.get("title").getAsJsonArray().iterator()).map(JsonElement::toString).collect(Collectors.toList()));
            } else if (root.has("title") && !root.get("title").isJsonNull()) {
                responseObj.setTitles(Collections.singletonList(root.get("title").getAsString()));
            }
            if (root.has("description") && !root.get("description").isJsonNull()) {
                responseObj.setDescription(root.get("description").getAsString());
            }
            if (root.has("author") && root.get("author").isJsonArray()) {
                DnetStreamSupport.generateStreamFromIterator((Iterator)root.getAsJsonArray("author").iterator()).map(JsonElement::getAsJsonObject).forEach(it -> {
                    if (it.has("literal")) {
                        authors.add(it.get("literal").getAsString());
                    } else {
                        authors.add(DataciteResolver.getStringValue(it, "given", " ") + " " + DataciteResolver.getStringValue(it, "family", " "));
                    }
                });
            }
            responseObj.setAuthors((List)authors);
            String date = DataciteResolver.getStringValue(root, "registered", "");
            responseObj.setDate(date);
            DLIObjectProvenance provenance = new DLIObjectProvenance();
            DLIPIDResolver.setDatasourceProvenance((ObjectProvenance)provenance, DATACITE_NS_PREFIX);
            responseObj.setDatasourceProvenance((List)Lists.newArrayList((Object[])new ObjectProvenance[]{provenance}));
            responseObj.setCompletionStatus(CompletionStatus.complete.toString());
            return responseObj;
        }
        return null;
    }

    protected boolean canResolvePid(String pidType) {
        return pidType != null && ("doi".equals(pidType.toLowerCase().trim()) || "handle".equals(pidType.toLowerCase().trim()));
    }

    public DLIResolvedObject resolve(String pid, String pidType) {
        try {
            String response = DataciteResolver.requestURL((String)(baseURL + pid.replace(" ", "%20")));
            return DataciteResolver.parseResponse(response);
        }
        catch (Throwable e) {
            log.error((Object)("Error on getting item from url https://api.datacite.org/works/" + pid.replace(" ", "%20")));
            return null;
        }
    }
}

