/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.SubjectType;
import eu.dnetlib.pid.resolver.parser.AbstractResolverParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenAireParser
extends AbstractResolverParser {
    private static final Log log = LogFactory.getLog(OpenAireParser.class);

    public DLIResolvedObject parseObject(String record) {
        try {
            List resutlTypes;
            List descriptions;
            List authorNodes;
            List titles;
            DLIResolvedObject currentObject = new DLIResolvedObject();
            VTDGen vg = new VTDGen();
            vg.setDoc(record.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            ap.declareXPathNameSpace("oaf", "http://namespace.openaire.eu/oaf");
            List subjectNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//oaf:result//subject", Arrays.asList("classname", "schemename"));
            if (subjectNodes != null && subjectNodes.size() > 0) {
                ArrayList currentSubjects = new ArrayList();
                subjectNodes.forEach(it -> currentSubjects.add(new SubjectType((String)it.getAttributes().get("schemename"), it.getTextValue())));
                currentObject.setSubjects(currentSubjects);
            }
            if ((titles = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//oaf:result/title")) != null && titles.size() > 0) {
                currentObject.setTitles(titles);
            }
            if ((authorNodes = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//oaf:result//fullname")) != null && authorNodes.size() > 0) {
                currentObject.setAuthors(authorNodes);
            }
            if ((descriptions = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//oaf:result//description")) != null && descriptions.size() > 0) {
                currentObject.setDescription((String)descriptions.get(0));
            }
            if ((resutlTypes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//oaf:result/resulttype", Arrays.asList("classid"))) != null && resutlTypes.size() > 0) {
                String type = (String)((VtdUtilityParser.Node)resutlTypes.get(0)).getAttributes().get("classid");
                this.setType((ResolvedObject)currentObject, type);
            }
            return currentObject;
        }
        catch (Throwable e) {
            log.error((Object)"Error on parsing object ", e);
            return null;
        }
    }
}

