/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dli.resolver.OpenAireParser;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenaireResolver
extends AbstractPIDResolver {
    private static final String templateURL = "objidentifier:\"%s\"";
    private static final String OPENAIRE_NS_PREFIX = "openaire____";
    private static final String baseURL = "http://solr.openaire.eu:8983/solr/TMF-index-openaire_shard1_replica1/select?q=%s&wt=json";
    private static final Log log = LogFactory.getLog(OpenaireResolver.class);
    private final OpenAireParser parser = new OpenAireParser();

    protected boolean canResolvePid(String pidType) {
        return pidType != null && pidType.toLowerCase().equals("openaire");
    }

    protected DLIResolvedObject resolve(String pid, String pidType) {
        try {
            String currentQuery = String.format(baseURL, URLEncoder.encode(String.format(templateURL, pid.replace("oai:dnet:", "")), "UTF-8"));
            DLIResolvedObject obj = this.parsingResponse(OpenaireResolver.requestURL((String)currentQuery));
            if (obj == null) {
                return null;
            }
            obj.setPidType(pidType);
            obj.setPid(pid);
            return obj;
        }
        catch (Throwable e) {
            log.error((Object)("Error on resolve pid " + pid), e);
            return null;
        }
    }

    private DLIResolvedObject parsingResponse(String response) {
        if (response == null) {
            return null;
        }
        JsonElement jElement = new JsonParser().parse(response);
        JsonObject jobject = jElement.getAsJsonObject();
        if (jobject.has("response")) {
            long total = jobject.get("response").getAsJsonObject().get("numFound").getAsLong();
            if (total == 0L) {
                return null;
            }
            JsonArray hits = ((JsonObject)jobject.get("response")).get("docs").getAsJsonArray();
            JsonElement s = ((JsonObject)hits.get(0)).get("__result").getAsJsonArray().get(0);
            DLIResolvedObject resolvedObject = this.parser.parseObject(s.getAsString());
            resolvedObject.setRelations((List)Lists.newArrayList());
            DLIObjectProvenance op = new DLIObjectProvenance();
            op.setDatasource("OpenAIRE");
            op.setDatasourceId("dli_________::openaire");
            op.setCompletionStatus(CompletionStatus.complete.toString());
            op.setProvisionMode("resolved");
            resolvedObject.setCompletionStatus(CompletionStatus.complete.toString());
            resolvedObject.setDatasourceProvenance(Arrays.asList(op));
            return resolvedObject;
        }
        return null;
    }
}

