/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.pid.resolver.parser.AbstractResolverParser;
import eu.dnetlib.resolver.parser.DMFResolverParser;
import eu.dnetlib.resolver.parser.PMFResolverParser;
import eu.dnetlib.resolver.parser.ScholixResolverParser;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;

public class FilterDLIRecordJobNode
extends SimpleJobNode {
    private final DMFResolverParser dmfResolverParser = new DMFResolverParser();
    private final PMFResolverParser pmfResolverParser = new PMFResolverParser();
    private final ScholixResolverParser scholixResolverParser = new ScholixResolverParser();
    private String type;
    private String inputEprParam;
    private String outputEprParam;
    @Autowired
    private ResultSetFactory resultSetFactory;

    protected String execute(Env env) throws Exception {
        ResultSet outputResultSet;
        ResultSet rsIn = (ResultSet)env.getAttribute(this.inputEprParam, ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        switch (this.type) {
            case "publication": {
                outputResultSet = this.resultSetFactory.map(rsIn, String.class, this.createMappingFuncion(this.pmfResolverParser));
                break;
            }
            case "dataset": {
                outputResultSet = this.resultSetFactory.map(rsIn, String.class, this.createMappingFuncion(this.dmfResolverParser));
                break;
            }
            case "unknown": {
                outputResultSet = this.resultSetFactory.map(rsIn, String.class, this.createMappingFuncion(this.scholixResolverParser));
                break;
            }
            default: {
                throw new MSROException("unexpectd value of type");
            }
        }
        env.setAttribute(this.outputEprParam, (Object)outputResultSet);
        return Arc.DEFAULT_ARC;
    }

    private Function<String, String> createMappingFuncion(AbstractResolverParser parser) {
        return it -> {
            DLIResolvedObject resolvedObject = (DLIResolvedObject)parser.parseObject(it);
            if (resolvedObject != null) {
                return it;
            }
            return "<JUNK/>";
        };
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }
}

