/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindLastTsJobNode
extends SimpleJobNode
implements ProcessAware {
    private static final Log log = LogFactory.getLog(FindLastTsJobNode.class);
    private String overrideDate;
    private WorkflowProcess process;
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;

    protected String execute(Env env) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.overrideDate)) {
            long d = Long.parseLong(this.overrideDate);
            log.info((Object)("Found override params to " + d));
            env.setAttribute("incremental_date", (Object)d);
        } else {
            long fromDate = this.calculateFromDate();
            log.info((Object)("Last execution date " + fromDate));
            env.setAttribute("incremental_date", (Object)fromDate);
        }
        return Arc.DEFAULT_ARC;
    }

    private Long calculateFromDate() {
        long d = this.findLastSuccessStartDate();
        LocalDateTime zdt = LocalDateTime.ofInstant(Instant.ofEpochMilli(d), ZoneId.of("Etc/UTC"));
        return zdt.toEpochSecond(ZoneOffset.UTC);
    }

    private long findLastSuccessStartDate() {
        long res = -1L;
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("system:profileTemplateId", this.process.getProfileId());
        query.put("system:parentProfileId", this.process.getParentProfileId());
        query.put("system:processStatus", "SUCCESS");
        Iterator mapIterator = this.dnetLogger.find(query);
        Optional<Long> maxDate = DnetStreamSupport.generateStreamFromIterator((Iterator)mapIterator).map(it -> (String)it.get("system:startDate")).map(Long::parseLong).max(Long::compare);
        if (maxDate.isPresent()) {
            return maxDate.get();
        }
        return -1L;
    }

    public String getOverrideDate() {
        return this.overrideDate;
    }

    public void setOverrideDate(String overrideDate) {
        this.overrideDate = overrideDate;
    }

    public DnetLogger getDnetLogger() {
        return this.dnetLogger;
    }

    public void setDnetLogger(DnetLogger dnetLogger) {
        this.dnetLogger = dnetLogger;
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }
}

