/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class FindDedupConfigurationJobNode
extends SimpleJobNode {
    private String configName;
    @Autowired
    UniqueServiceLocator uniqueServiceLocator;
    private static final String query = "for $x in collection('/db/DRIVER/DedupConfigurationDSResources/DedupConfigurationDSResourceType') where $x//RESOURCE_IDENTIFIER/@value ='%s' return $x//DEDUPLICATION/text()";

    protected String execute(Env env) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.configName)) {
            throw new IllegalArgumentException("missing configuration sequence");
        }
        env.setAttribute("dconf", (Object)this.getProfile());
        return Arc.DEFAULT_ARC;
    }

    private String getProfile() throws Exception {
        ISLookUpService service = (ISLookUpService)this.uniqueServiceLocator.getService(ISLookUpService.class);
        List resourceProfile = service.quickSearchProfile(String.format(query, this.configName));
        if (resourceProfile.size() != 1) {
            throw new IllegalStateException("Query should return on result query:" + String.format(query, this.configName));
        }
        return FindDedupConfigurationJobNode.compressArgument((String)resourceProfile.get(0));
    }

    private static String compressArgument(String value) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(value.getBytes());
        gzip.close();
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }
}

