/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.resolver.parser;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIObjectRelation;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.dli.resolver.model.OAFHostedBy;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.parser.AbstractResolverParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PMFResolverParser
extends AbstractResolverParser {
    public DLIResolvedObject parseObject(String record) {
        try {
            List hostedBy;
            DLIResolvedObject parsedObject = new DLIResolvedObject();
            VTDGen vg = new VTDGen();
            vg.setDoc(record.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            String resolvedDate = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resolvedDate']");
            parsedObject.setResolvedDate(resolvedDate);
            List pid = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='pid']", Arrays.asList("type"));
            if (this.extractIdentifier((ResolvedObject)parsedObject, pid, "type")) {
                return null;
            }
            String provisionMode = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='provisionMode']");
            List collectedFromNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='collectedFrom']", Arrays.asList("name", "id", "mode", "completionStatus"));
            List resolvededFromNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resolvedFrom']", Arrays.asList("name", "id", "mode", "completionStatus"));
            String publisher = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='publisher']");
            ArrayList provenances = new ArrayList();
            if (collectedFromNodes != null && collectedFromNodes.size() > 0) {
                collectedFromNodes.forEach(it -> {
                    DLIObjectProvenance provenance = new DLIObjectProvenance();
                    provenance.setDatasourceId((String)it.getAttributes().get("id"));
                    provenance.setDatasource((String)it.getAttributes().get("name"));
                    provenance.setProvisionMode(provisionMode);
                    provenance.setCompletionStatus((String)it.getAttributes().get("completionStatus"));
                    provenance.setPublisher(publisher);
                    provenances.add(provenance);
                });
            }
            if (resolvededFromNodes != null && resolvededFromNodes.size() > 0) {
                resolvededFromNodes.forEach(it -> {
                    DLIObjectProvenance provenance = new DLIObjectProvenance();
                    provenance.setDatasourceId((String)it.getAttributes().get("id"));
                    provenance.setDatasource((String)it.getAttributes().get("name"));
                    provenance.setProvisionMode("resolved");
                    provenance.setCompletionStatus((String)it.getAttributes().get("completionStatus"));
                    provenances.add(provenance);
                });
            }
            parsedObject.setDatasourceProvenance(provenances);
            parsedObject.setCompletionStatus(VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='completionStatus']"));
            List relatedIdentifiers = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='relatedIdentifier']", Arrays.asList("relatedIdentifierType", "relationType", "entityType", "inverseRelationType"));
            if (relatedIdentifiers != null && relatedIdentifiers.size() > 0) {
                ArrayList relations = new ArrayList();
                relatedIdentifiers.forEach(relation -> {
                    String currentPid = relation.getTextValue();
                    String currentPidType = (String)relation.getAttributes().get("relatedIdentifierType");
                    String currentType = relation.getAttributes().containsKey("entityType") ? (String)relation.getAttributes().get("entityType") : "unknown";
                    DLIObjectRelation currentRelation = new DLIObjectRelation();
                    currentRelation.setTargetPID(new PID(currentPid, currentPidType));
                    currentRelation.setCompletionStatus(CompletionStatus.incomplete.toString());
                    currentRelation.setSourcePid(parsedObject.getPid());
                    currentRelation.setRelationSemantics((String)relation.getAttributes().get("relationType"));
                    currentRelation.setInverseRelation((String)relation.getAttributes().get("inverseRelationType"));
                    currentRelation.setTargetType(ObjectType.valueOf((String)currentType));
                    if (parsedObject.getDatasourceProvenance() != null && parsedObject.getDatasourceProvenance().size() > 0) {
                        DLIObjectProvenance provenance = (DLIObjectProvenance)parsedObject.getDatasourceProvenance().get(0);
                        DLIObjectProvenance newProvenance = new DLIObjectProvenance();
                        newProvenance.setCompletionStatus(CompletionStatus.incomplete.toString());
                        newProvenance.setDatasourceId(provenance.getDatasourceId());
                        newProvenance.setDatasource(provenance.getDatasource());
                        newProvenance.setProvisionMode(provenance.getProvisionMode());
                        currentRelation.setRelationProvenance(Arrays.asList(newProvenance));
                    }
                    relations.add(currentRelation);
                });
                parsedObject.setRelations(relations);
            }
            if ((hostedBy = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='hostedBy']", Arrays.asList("id", "name"))) != null) {
                hostedBy.stream().map(it -> new OAFHostedBy((String)it.getAttributes().get("id"), (String)it.getAttributes().get("name"))).forEach(arg_0 -> ((DLIResolvedObject)parsedObject).setHostedBy(arg_0));
            }
            List authorsNode = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='creator']");
            parsedObject.setAuthors(authorsNode);
            parsedObject.setTitles(VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='title']"));
            parsedObject.setDescription(VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='description']"));
            parsedObject.setDate(VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='date']"));
            List subjects = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='subject']", Arrays.asList("scheme"));
            this.extractSubject((ResolvedObject)parsedObject, subjects);
            this.setType((ResolvedObject)parsedObject, VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='type']"));
            return parsedObject;
        }
        catch (Throwable e) {
            log.error((Object)("Input record: " + record));
            log.error((Object)"Error on parsing record ", e);
            return null;
        }
    }
}

