package eu.dnetlib.dli.collector.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIObjectRelation;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import org.antlr.stringtemplate.NoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CrossRefIterator implements Iterator<String> {

    private static final Log log = LogFactory.getLog(CrossRefIterator.class);

    private int current = 0;
    private int total =0;
    private String nextCursor;


    private final  StringTemplate resolverSerializer;

    private List<JsonElement> buffer = new ArrayList<>();
    private String nextItem;


    public CrossRefIterator(final StringTemplate resolverSerializer) {
        this.resolverSerializer = resolverSerializer;
        nextItem = calculateNextItem();
    }


    @Override
    public boolean hasNext() {
        return nextItem != null;
    }

    @Override
    public String next() {
        final String tmp = nextItem;
        nextItem = calculateNextItem();
        current ++;
        return tmp;
    }


    private String calculateNextItem() {

        if (buffer.isEmpty())
        {
            if (!requestNextBuffer()) return null;
        }
        if (buffer.isEmpty()) return null;
        final JsonObject item = buffer.remove(0).getAsJsonObject();
        try {
            final DLIResolvedObject object = new DLIResolvedObject();
            final String id = item.get("Source").getAsJsonObject().get("Identifier").getAsJsonObject().get("ID").getAsString();
            final String id_type = item.get("Source").getAsJsonObject().get("Identifier").getAsJsonObject().get("IDScheme").getAsString();
            object.setPid(id);
            object.setPidType(id_type);
            final JsonElement licenseURL = item.get("LicenseURL");



            final String type = item.get("Source").getAsJsonObject().get("Type").getAsJsonObject().get("Name").isJsonNull()?"unknownw":item.get("Source").getAsJsonObject().get("Type").getAsJsonObject().get("Name").getAsString();
            object.setType(type.equals("literature") ? ObjectType.publication : ObjectType.dataset);
            final String relType = item.get("RelationshipType").getAsJsonObject().get("Name").getAsString();
            object.setDatasourceProvenance(Collections.singletonList(new DLIObjectProvenance().setDatasource("Crossref").setDatasourceId("dli_________::crossref")));
            DLIObjectRelation relation = new DLIObjectRelation();
            relation.setRelationSemantics(relType);
            final String t_id = item.get("Target").getAsJsonObject().get("Identifier").getAsJsonObject().get("ID").getAsString();
            final String t_id_type = item.get("Target").getAsJsonObject().get("Identifier").getAsJsonObject().get("IDScheme").getAsString();

            final String t_type = item.get("Target").getAsJsonObject().get("Type").getAsJsonObject().get("Name").isJsonNull()?"unknown":item.get("Target").getAsJsonObject().get("Type").getAsJsonObject().get("Name").getAsString();

            if (licenseURL!= null && !licenseURL.isJsonNull())
                relation.setLicense(licenseURL.getAsString());
            relation.setTargetPID(new PID(t_id, t_id_type));
            relation.setTargetType(t_type.equals("literature") ? ObjectType.publication : ObjectType.dataset);
            object.setRelations(Collections.singletonList(relation));
            relation.setCompletionStatus("incomplete");
            relation.setRelationProvenance(Collections.singletonList(new DLIObjectProvenance().setDatasource("Crossref").setDatasourceId("dli_________::crossref")));
            try {
                StringWriter writer = new StringWriter(16);
                NoIndentWriter out = new NoIndentWriter(writer);
                resolverSerializer.removeAttribute("object");
                resolverSerializer.setAttribute("object", object);
                resolverSerializer.write(out);
                String result = writer.toString();
                writer.close();
                return result;
            } catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }catch (Throwable e) {
            System.out.println(item.toString());
            throw new RuntimeException(e);
        }
    }

    private boolean requestNextBuffer() {
        String templateUrlWithCursor = "https://api.eventdata.crossref.org/v1/events/scholix?mailto=sandro.labruzzo@isti.cnr.it&rows=1000&cursor=%s";
        String templateUrl = "https://api.eventdata.crossref.org/v1/events/scholix?mailto=sandro.labruzzo@isti.cnr.it&rows=1000";
        final String s = AbstractPIDResolver.requestURL(nextCursor == null ? templateUrl : String.format(templateUrlWithCursor, nextCursor), 30, 2);
        if (s!= null)
        {
            JsonElement jElement = new JsonParser().parse(s);
            if (jElement.getAsJsonObject().has("message"))
            {
                JsonObject message = jElement.getAsJsonObject().get("message").getAsJsonObject();
                if (message.has("next-cursor") && !message.get("next-cursor").isJsonNull())
                    nextCursor = message.get("next-cursor").getAsString();
                else
                    nextCursor = null;
                total = message.get("total-results").getAsInt();
                final JsonArray items = message.get("link-packages").getAsJsonArray();
                if (items== null || items.size() ==0) {
                    return requestNextBuffer();
                }

                items.forEach(buffer::add);
                return nextCursor!=null;
            }
        }
        return false;
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }
}
