package eu.dnetlib.dli.collector.plugin;

import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import eu.dnetlib.rmi.data.plugin.CollectorPlugin;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

public class DataciteCollectorPlugin extends AbstractCollectorPlugin implements CollectorPlugin {


    @Override
    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {

        long timestamp= 0;
        if (StringUtils.isNotBlank(fromDate)) {
            Date parsed = new DateUtils().parse(fromDate);
            timestamp =parsed.getTime() /1000;
        }

        final long finalTimestamp = timestamp;
        return () -> {
            try {
                return new DataciteESIterator(finalTimestamp);
            } catch (Exception e) {
                throw new RuntimeException(e );
            }
        };
    }

}
