package eu.dnetlib.dli.collector.plugin;

import eu.dnetlib.dli.resolver.model.serializer.DLIResolverSerializer;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import eu.dnetlib.rmi.data.plugin.CollectorPlugin;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Objects;


class ScholixIterator implements Iterator<String> {
    private static final Log log = LogFactory.getLog(ScholixIterator.class);

    private final Iterator<Path> pathIterator;
    private Iterator<String> currentIterator;
    private String nextItem;
    private final DLIResolverSerializer serializer;

    private final static String template ="<record xmlns:oaf=\"http://namespace.dnet.eu/oaf\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">%s</record>";



    public ScholixIterator(DirectoryStream<Path> pathIterator,DLIResolverSerializer serializer ) {
        this.pathIterator = pathIterator.iterator();
        this.serializer = serializer;
        nextItem =generateNextItem();

    }


    private String generateNextItem() {
        if (currentIterator== null || !currentIterator.hasNext()) {
            getNextIterator();
            if (currentIterator!= null && currentIterator.hasNext())
                return currentIterator.next();
            return null;
        } else {
            return currentIterator.next();
        }
    }


    private void getNextIterator() {
        if (pathIterator.hasNext()) {
            try {
                final Path nextPath = pathIterator.next();
                log.debug("Request Next Iterator NextPath :"+nextPath.getFileName());
                currentIterator = Files.lines(nextPath).map(ScholixJSONParser::parse).filter(Objects::nonNull).map(serializer::serializeToXML).map(it->String.format(template,it)).iterator();
            } catch (Throwable e) {
                throw new RuntimeException("Error on generating next Iterator ",e);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return nextItem!= null;
    }

    @Override
    public String next() {
        final  String tmp = nextItem;
        nextItem = generateNextItem();
        return tmp;


    }
}

public class ScholixFromFSCollectorPlugin extends AbstractCollectorPlugin implements CollectorPlugin {
    private static final Log log = LogFactory.getLog(ScholixFromFSCollectorPlugin.class);

    @Autowired
    private DLIResolverSerializer serializer;

    @Override
    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        try {
            final String baseUrl = interfaceDescriptor.getBaseUrl();
            final Path dir = FileSystems.getDefault().getPath(baseUrl);
            final DirectoryStream<Path> pathIterator = Files.newDirectoryStream(dir, "*json");            ;
            return () -> new ScholixIterator(pathIterator, serializer);
        } catch (Throwable e) {
            throw  new CollectorServiceException(e);
        }
    }

    public DLIResolverSerializer getSerializer() {
        return serializer;
    }

    public void setSerializer(DLIResolverSerializer serializer) {
        this.serializer = serializer;
    }
}
