package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.annotation.Resource;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class FindLastTsJobNode extends SimpleJobNode implements ProcessAware {
    private static final Log log = LogFactory.getLog(FindLastTsJobNode.class);
    private String overrideDate;

    private WorkflowProcess process;

    @Resource(name = "msroWorkflowLogger")
    private DnetLogger dnetLogger;

    @Override
    protected String execute(final Env env) throws Exception {

        if (StringUtils.isNotBlank(overrideDate)) {
            final long d = Long.parseLong(overrideDate);
            log.info("Found override params to " + d);
            env.setAttribute("incremental_date", d);

        } else {
            final long fromDate = calculateFromDate();
            log.info("Last execution date " + fromDate);
            env.setAttribute("incremental_date", fromDate);
        }
        return Arc.DEFAULT_ARC;
    }

    private Long calculateFromDate() {
        final long d = findLastSuccessStartDate();
        LocalDateTime zdt = LocalDateTime.ofInstant(Instant.ofEpochMilli(d), ZoneId.of("Etc/UTC"));
        return zdt.toEpochSecond(ZoneOffset.UTC);
    }

    private long findLastSuccessStartDate() {
        final long res = -1;
        // TODO find the right condition to obtain the list of the previous executions
        //dnetLogger.
        final Map<String, Object> query = new HashMap<>();
        query.put("system:profileTemplateId", process.getProfileId());
        query.put("system:parentProfileId", process.getParentProfileId());
        query.put("system:processStatus", "SUCCESS");
        Iterator<Map<String, String>> mapIterator = dnetLogger.find(query);
        Optional<Long> maxDate = DnetStreamSupport.generateStreamFromIterator(mapIterator).map(it -> it.get("system:startDate")).map(Long::parseLong).max(Long::compare);
        if (maxDate.isPresent())
            return maxDate.get();
        else
            return -1;
    }

    public String getOverrideDate() {
        return overrideDate;
    }

    public void setOverrideDate(String overrideDate) {
        this.overrideDate = overrideDate;
    }

    public DnetLogger getDnetLogger() {
        return dnetLogger;
    }

    public void setDnetLogger(DnetLogger dnetLogger) {
        this.dnetLogger = dnetLogger;
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    @Override
    public void setProcess(final WorkflowProcess process) {
        this.process = process;
    }

}
