<?xml version="1.0" encoding="UTF-8"?>
<RESOURCE_PROFILE>
    <HEADER>
        <RESOURCE_IDENTIFIER value=""/>
        <RESOURCE_TYPE value="WorkflowDSResourceType"/>
        <RESOURCE_KIND value="WorkflowDSResources"/>
        <RESOURCE_URI value=""/>
        <DATE_OF_CREATION value=""/>
    </HEADER>
    <BODY>
        <WORKFLOW_NAME>$name$</WORKFLOW_NAME>
        <WORKFLOW_DESCRIPTION>$desc$</WORKFLOW_DESCRIPTION>
        <WORKFLOW_INFO />
        <WORKFLOW_FAMILY>aggregator</WORKFLOW_FAMILY>
        <WORKFLOW_PRIORITY>$priority$</WORKFLOW_PRIORITY>
        <DATASOURCE id="$dsId$" interface="$interface$" />
        <CONFIGURATION status="WAIT_SYS_SETTINGS" start="MANUAL">
            <PARAMETERS>
            	<PARAM name="collMdstoreId"                     description="Store for collected records"           required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="cleanMdstoreId"                    description="Store for cleaned records"             required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="publicationMdstoreId"              description="Store for publication records"         required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="dataSetMdstoreId"                  description="Store for dataSets records"            required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="unknownMdstoreId"                  description="Store for unknown records"             required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="cleanTransformationRuleId"         description="Transformation Rule Identifier"        required="true" managedBy="user"   category="TRANSFORMATION_RULE_ID" type="string" function="listProfiles('TransformationRuleDSResourceType', '//TITLE', 'DLI:')"/>
            	<PARAM description="Type of Transformation" function="validValues(['simpleTransform', 'transformAndUnpack'])" managedBy="user" name="typeOfTransform" required="true" type="string">simpleTransform</PARAM>
            	<PARAM description="Incremental Transformation" function="validValues(['INCREMENTAL', 'REFRESH'])" managedBy="user" name="collectionMode" required="false" type="string">REFRESH</PARAM>
            	<PARAM description="Resolving offline" function="validValues(['false', 'true'])" managedBy="user" name="offlineResolving" required="true" type="string">false</PARAM>
            	<PARAM name="from_date"                         description="Start Date of Harvesting"              required="false" managedBy="user"   category="COLLECTION" type="string"/>
            </PARAMETERS>
            <WORKFLOW>
                <NODE isStart="true" name="collection" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Collect records</DESCRIPTION>
                    <PARAMETERS>
                    	<PARAM name="wfTemplateId" value="6f3e63a0-70cb-4123-8528-ed7519eb9eb4_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                    	<PARAM name="wfTemplateParams">
                    		<MAP>
                    			<ENTRY key="dsId"           value="$dsId$" />
 								<ENTRY key="interface"      value="$interface$" />
	 							<ENTRY key="collMdstoreId"  ref="collMdstoreId" />
	 							<ENTRY key="collectionMode"  ref="collectionMode" />
	 							<ENTRY key="from_date"      ref="from_date" />
                    		</MAP>
                    	</PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="transform"/>
                    </ARCS>
                </NODE>
                <NODE name="transform" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Transform records</DESCRIPTION>
                    <PARAMETERS>
                    	<PARAM name="wfTemplateId" value="da3531c6-2bf6-48ab-848b-bd4c6379fd65_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                    	<PARAM name="wfTemplateParams">
                    		<MAP>
                    			<ENTRY key="dsId"                   value="$dsId$" />
 								<ENTRY key="interface"              value="$interface$" />
 								<ENTRY key="collMdstoreId"          ref="collMdstoreId" />
 								<ENTRY key="cleanMdstoreId"         ref="cleanMdstoreId" />
 								<ENTRY key="cleanRuleId"            ref="cleanTransformationRuleId" />
 								<ENTRY key="collectionMode"         ref="collectionMode" />
 								<ENTRY key="typeOfTransform"         ref="typeOfTransform" />

 							</MAP>
 						</PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="pidResolver"/>
                    </ARCS>
                </NODE>
                <NODE name="pidResolver" type="LaunchWorkflowTemplate">
                        <DESCRIPTION>Transform records</DESCRIPTION>
                        <PARAMETERS>
                            <PARAM name="wfTemplateId" value="a42e8225-d5be-4658-9a6b-9c5529aed993_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                            <PARAM name="wfTemplateParams">
                                <MAP>
                                    <ENTRY key="dsId"                   value="$dsId$" />
                                    <ENTRY key="interface"              value="$interface$" />
                                    <ENTRY key="collMdstoreId"          ref="collMdstoreId" />
                                    <ENTRY key="cleanMdstoreId"         ref="cleanMdstoreId" />
                                    <ENTRY key="offlineResolving"       ref="offlineResolving" />
                                    <ENTRY key="collectionMode"         ref="collectionMode" />
                                    <ENTRY key="nsPrefix" ref="nsPrefix"/>
                                </MAP>
                            </PARAM>
                        </PARAMETERS>
                        <ARCS>
                            <ARC to="filterResolvedPublication"/>
                            <ARC to="filterResolvedDataSet"/>
                            <ARC to="filterResolvedUnknown"/>
                        </ARCS>
                </NODE>

                <NODE name="filterResolvedPublication" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Transform records</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="4c73bc04-427c-4e28-ad59-f639f5a9c522_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="filterType"             value="publication" />
                                <ENTRY key="destinationMdStoreId"   ref="publicationMdstoreId" />
                                <ENTRY key="cleanMdstoreId"         ref="cleanMdstoreId" />

                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="success"/>
                    </ARCS>
                 </NODE>


                 <NODE name="filterResolvedDataSet" type="LaunchWorkflowTemplate">
                     <DESCRIPTION>Transform records</DESCRIPTION>
                     <PARAMETERS>
                         <PARAM name="wfTemplateId" value="4c73bc04-427c-4e28-ad59-f639f5a9c522_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                         <PARAM name="wfTemplateParams">
                             <MAP>
                                 <ENTRY key="filterType"             value="dataset" />
                                 <ENTRY key="destinationMdStoreId"   ref="dataSetMdstoreId" />
                                 <ENTRY key="cleanMdstoreId"         ref="cleanMdstoreId" />

                             </MAP>
                         </PARAM>
                     </PARAMETERS>
                     <ARCS>
                         <ARC to="success"/>
                     </ARCS>
                  </NODE>

                 <NODE name="filterResolvedUnknown" type="LaunchWorkflowTemplate">
                     <DESCRIPTION>Transform records</DESCRIPTION>
                     <PARAMETERS>
                         <PARAM name="wfTemplateId" value="4c73bc04-427c-4e28-ad59-f639f5a9c522_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                         <PARAM name="wfTemplateParams">
                             <MAP>
                                 <ENTRY key="filterType"             value="unknown" />
                                 <ENTRY key="destinationMdStoreId"   ref="unknownMdstoreId"/>
                                 <ENTRY key="cleanMdstoreId"         ref="cleanMdstoreId" />

                             </MAP>
                         </PARAM>
                     </PARAMETERS>
                     <ARCS>
                         <ARC to="success"/>
                     </ARCS>
                  </NODE>
            </WORKFLOW>

            <DESTROY_WORKFLOW_TEMPLATE id="8bf9879c-535a-4818-8de7-790a3eb90675_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==">
                            <PARAMETERS>
                                <PARAM name="dsId"                  value="$dsId$" />
                                <PARAM name="interface"             value="$interface$" />
                                <PARAM name="DLINativeStore" 		ref="collMdstoreId" />
                                <PARAM name="DLICleanedStore" 		ref="cleanMdstoreId" />
                                <PARAM name="PMFResolvedStore" 		ref="publicationMdstoreId" />
                                <PARAM name="DMFResolvedStore" 		ref="dataSetMdstoreId" />
                                <PARAM name="ScholixResolvedStore" 	ref="unknownMdstoreId" />
                            </PARAMETERS>
            </DESTROY_WORKFLOW_TEMPLATE>


                </CONFIGURATION>

                <NOTIFICATIONS/>

                <SCHEDULING enabled="false">
                    <CRON>9 9 9 ? * *</CRON>
                    <MININTERVAL>10080</MININTERVAL>
                </SCHEDULING>
                <STATUS/>
            </BODY>
</RESOURCE_PROFILE>
