package eu.dnetlib.dli.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.data.transform.VtdUtilityParser.Node;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.model.SubjectType;

import eu.dnetlib.pid.resolver.parser.AbstractResolverParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by sandro on 10/3/16.
 */
public class OpenAireParser extends AbstractResolverParser {

	private static final Log log = LogFactory.getLog(OpenAireParser.class);

	@Override
    public DLIResolvedObject parseObject(final String record) {
        try {
            final DLIResolvedObject currentObject = new DLIResolvedObject();
            final VTDGen vg = new VTDGen();
			vg.setDoc(record.getBytes());
			vg.parse(true);

			final VTDNav vn = vg.getNav();
			final AutoPilot ap = new AutoPilot(vn);

			ap.declareXPathNameSpace("oaf", "http://namespace.openaire.eu/oaf");

			final List<Node> subjectNodes =
					VtdUtilityParser.getTextValuesWithAttributes(ap, vn, "//oaf:result//subject", Arrays.asList("classname", "schemename"));

			//Setting subjects
			if (subjectNodes != null && subjectNodes.size() > 0) {
				final List<SubjectType> currentSubjects = new ArrayList<>();

				subjectNodes.forEach(it ->
						currentSubjects.add(new SubjectType(it.getAttributes().get("schemename"), it.getTextValue()))
				);
				currentObject.setSubjects(currentSubjects);
			}

			//Setting Titles
			final List<String> titles = VtdUtilityParser.getTextValue(ap, vn, "//oaf:result/title");

			if (titles != null && titles.size() > 0) {
				currentObject.setTitles(titles);
			}

			//Setting authors
			final List<String> authorNodes = VtdUtilityParser.getTextValue(ap, vn, "//oaf:result//fullname");
			if (authorNodes != null && authorNodes.size() > 0) {
				currentObject.setAuthors(authorNodes);
			}

			//Setting descriptions
			final List<String> descriptions = VtdUtilityParser.getTextValue(ap, vn, "//oaf:result//description");
			if (descriptions != null && descriptions.size() > 0) {
				currentObject.setDescription(descriptions.get(0));
			}

			//resulttype classid
			final List<Node> resutlTypes = VtdUtilityParser.getTextValuesWithAttributes(ap, vn, "//oaf:result/resulttype", Arrays.asList("classid"));
			if (resutlTypes != null && resutlTypes.size() > 0) {
				final String type = resutlTypes.get(0).getAttributes().get("classid");
				setType(currentObject, type);
			}

			return currentObject;
		} catch (Throwable e) {
			log.error("Error on parsing object ", e);
			return null;
		}
	}

}
