/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.QueryBuilder;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.dli.resolver.model.DLIResolvedObjectDeserializer;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;

public class DLIOfflineResolver
extends AbstractPIDResolver {
    private static final Log log = LogFactory.getLog(DLIOfflineResolver.class);
    @Autowired
    private MongoClient mongoClient;
    private MongoDatabase db;
    private Gson g = new GsonBuilder().registerTypeAdapter(DLIResolvedObject.class, (Object)new DLIResolvedObjectDeserializer()).create();

    protected boolean canResolvePid(String pidType) {
        return true;
    }

    protected DLIResolvedObject resolve(String pid, String pidType) {
        String dliItem = this.retrieveDLIFromDump(pid.toLowerCase().trim(), pidType.toLowerCase().trim());
        if (dliItem != null) {
            return (DLIResolvedObject)this.g.fromJson(dliItem, DLIResolvedObject.class);
        }
        return null;
    }

    private String retrieveDLIFromDump(String pid, String pidType) {
        DBObject query;
        MongoCollection crossRef;
        FindIterable documents;
        MongoCursor iterator;
        log.debug((Object)String.format("trying to find %s of type %s", pid, pidType));
        if (this.db == null) {
            this.db = this.mongoClient.getDatabase("dli_resolved");
        }
        if ((iterator = (documents = (crossRef = this.db.getCollection("dli")).find((Bson)(query = QueryBuilder.start((String)"pid").is((Object)pid).and("pid_type").is((Object)pidType).get())).limit(1)).iterator()).hasNext()) {
            log.debug((Object)("found pid " + pid));
            return ((Document)iterator.next()).get((Object)"body").toString();
        }
        return null;
    }
}

