/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import com.google.common.collect.Lists;
import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.dli.resolver.DLIPIDResolver;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.dli.resolver.model.ObjectProvisionMode;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.SubjectType;
import java.util.Arrays;
import java.util.List;

public class ENAParser {
    private static String ENA_NS_PREFIX = "r3d100010527";

    public DLIResolvedObject parser(String record, String pid, String pidType) throws Exception {
        VTDGen vg = new VTDGen();
        vg.setDoc(record.getBytes());
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        DLIResolvedObject result = new DLIResolvedObject();
        List textValuesWithAttributes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//ROOT/entry", Arrays.asList("taxonomicDivision", "moleculeType", "firstPublic"));
        if (textValuesWithAttributes == null || textValuesWithAttributes.isEmpty()) {
            return null;
        }
        result.setType(ObjectType.dataset);
        VtdUtilityParser.Node firstNode = (VtdUtilityParser.Node)textValuesWithAttributes.get(0);
        result.setDate((String)firstNode.getAttributes().get("firstPublic"));
        String moleculeType = (String)firstNode.getAttributes().get("moleculeType");
        String taxonomicDivision = (String)firstNode.getAttributes().get("taxonomicDivision");
        result.setSubjects(Arrays.asList(new SubjectType("moleculeType", moleculeType), new SubjectType("taxonomicDivision", taxonomicDivision)));
        result.setTitles(Arrays.asList(VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//ROOT/entry/description")));
        result.setPid(pid);
        result.setPidType(pidType);
        result.setCompletionStatus(CompletionStatus.complete.toString());
        DLIObjectProvenance provenance = new DLIObjectProvenance();
        provenance.setCompletionStatus(CompletionStatus.complete.toString());
        provenance.setProvisionMode(ObjectProvisionMode.resolved.toString());
        DLIPIDResolver.setDatasourceProvenance((ObjectProvenance)provenance, ENA_NS_PREFIX);
        result.setDatasourceProvenance((List)Lists.newArrayList((Object[])new ObjectProvenance[]{provenance}));
        return result;
    }
}

