/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.model.ObjectType;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NCBINParser {
    private static final Log log = LogFactory.getLog(NCBINParser.class);

    public DLIResolvedObject parseRecord(String record) {
        try {
            if (record == null || record.contains("ERROR")) {
                return null;
            }
            DLIResolvedObject parsedObject = new DLIResolvedObject();
            VTDGen vg = new VTDGen();
            vg.setDoc(record.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            parsedObject.setTitles(VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//Item[./@Name='Title']"));
            List dates = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//Item[./@Name='CreateDate']");
            if (dates != null && dates.size() > 0) {
                parsedObject.setDate((String)dates.get(0));
            }
            parsedObject.setType(ObjectType.dataset);
            return parsedObject;
        }
        catch (Throwable e) {
            log.error((Object)String.format("Error on parsing document %s", record), e);
            return null;
        }
    }
}

