/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.resolver.mdstore.plugin;

import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.dli.DLIUtils;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.dli.resolver.model.serializer.DLIResolverSerializer;
import eu.dnetlib.pid.resolver.PIDResolver;
import eu.dnetlib.pid.resolver.mdstore.plugin.AbstractRecordResolver;
import eu.dnetlib.pid.resolver.mdstore.plugin.ResolverSerializer;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.resolver.parser.DLIParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DLIRecordResolver
extends AbstractRecordResolver {
    private static final Log log = LogFactory.getLog(DLIRecordResolver.class);
    private final DLIParser parser = new DLIParser();

    public DLIRecordResolver(long ts, boolean forceResolver) {
        super(ts);
        this.forceResolver = forceResolver;
    }

    public String resolve(String inputRecord) {
        DLIResolvedObject inputObject = (DLIResolvedObject)this.parser.parse(inputRecord);
        if (inputObject == null) {
            return null;
        }
        if (!this.forceResolver && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{inputObject.getResolvedDate()})) {
            return null;
        }
        if (!StringUtils.isBlank((CharSequence)inputObject.getPid())) {
            log.debug((Object)("trying to resolve " + inputObject.getPid()));
        }
        boolean shouldUpdate = false;
        if (inputObject.getCompletionStatus() == null || !inputObject.getCompletionStatus().equals(CompletionStatus.complete.toString())) {
            shouldUpdate = this.tryToResolveRecord(inputObject);
        }
        return this.resolveRelations(inputRecord, (ResolvedObject)inputObject, shouldUpdate, s -> {
            try {
                return DLIUtils.getInverse((String)s);
            }
            catch (Exception e) {
                log.error((Object)("Error on getting Inverse relation from " + s), (Throwable)e);
                return "";
            }
        });
    }

    protected Map<String, ObjectType> tryToResolveRelation(PID currentPid) {
        if (currentPid.getId() != null && currentPid.getId().contains("dli_resolver")) {
            return null;
        }
        log.debug((Object)("tryToResolveRelation " + currentPid));
        DLIResolvedObject resolvedObject = (DLIResolvedObject)((PIDResolver)this.pluginResolver.get(0)).retrievePIDfromCache(currentPid.getId(), currentPid.getType());
        Map<String, ObjectType> result_from_cache = this.fixResolvedRelation(currentPid, resolvedObject);
        if (result_from_cache != null) {
            return result_from_cache;
        }
        for (PIDResolver resolver : this.pluginResolver) {
            DLIResolvedObject currentIdentifier = (DLIResolvedObject)resolver.retrievePID(currentPid.getId(), currentPid.getType(), this.offline);
            Map<String, ObjectType> result = this.fixResolvedRelation(currentPid, currentIdentifier);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Map<String, ObjectType> fixResolvedRelation(PID currentPid, DLIResolvedObject currentIdentifier) {
        if (currentIdentifier != null && !StringUtils.isBlank((CharSequence)currentIdentifier.getPid()) && currentIdentifier.getPid().toLowerCase().equals(currentPid.getId().toLowerCase())) {
            HashMap<String, ObjectType> result = new HashMap<String, ObjectType>();
            result.put("dli_resolver::" + DLIUtils.generateIdentifier((String)currentIdentifier.getPid(), (String)currentIdentifier.getPidType()), currentIdentifier.getType());
            return result;
        }
        return null;
    }

    private boolean tryToResolveRecord(DLIResolvedObject object) {
        DLIResolvedObject resolvedObject1 = (DLIResolvedObject)((PIDResolver)this.pluginResolver.get(0)).retrievePIDfromCache(object.getPid(), object.getPidType());
        if (this.fixResolvedObject(object, (PIDResolver)this.pluginResolver.get(0), resolvedObject1)) {
            return true;
        }
        for (PIDResolver resolver : this.pluginResolver) {
            DLIResolvedObject resolvedObject;
            if (!this.fixResolvedObject(object, resolver, resolvedObject = (DLIResolvedObject)resolver.retrievePID(object.getPid(), object.getPidType(), this.offline))) continue;
            return true;
        }
        log.debug((Object)("Record NOT Resolved  PID: " + object.getPid()));
        return false;
    }

    private boolean fixResolvedObject(DLIResolvedObject object, PIDResolver resolver, DLIResolvedObject resolvedObject) {
        if (resolvedObject != null && resolvedObject.getCompletionStatus() != null && resolvedObject.getCompletionStatus().equals(CompletionStatus.complete.toString())) {
            object.setAuthors(resolvedObject.getAuthors());
            object.setTitles(resolvedObject.getTitles());
            object.setCompletionStatus(resolvedObject.getCompletionStatus());
            object.setDate(resolvedObject.getDate());
            object.getDatasourceProvenance().addAll(resolvedObject.getDatasourceProvenance());
            object.setDescription(resolvedObject.getDescription());
            object.setSubjects(resolvedObject.getSubjects());
            object.setType(resolvedObject.getType());
            log.debug((Object)("Record Resolved by " + resolver.getClass().getCanonicalName() + "  PID: " + object.getPid()));
            return true;
        }
        return false;
    }

    public void setPluginResolver(List<PIDResolver> pluginResolver) {
        this.pluginResolver = pluginResolver;
    }

    public BlockingQueue<DBObject> getInputQueue() {
        return this.inputQueue;
    }

    public void setInputQueue(BlockingQueue<DBObject> inputQueue) {
        this.inputQueue = inputQueue;
    }

    public MongoCollection<DBObject> getOutputCollection() {
        return this.outputCollection;
    }

    public void setOutputCollection(MongoCollection<DBObject> outputCollection) {
        this.outputCollection = outputCollection;
    }

    public void setSerializer(ResolverSerializer serializer) {
        DLIResolverSerializer tmp = new DLIResolverSerializer();
        tmp.setPmfTemplate(new StringTemplate(((DLIResolverSerializer)serializer).getPmfTemplate().getTemplate()));
        tmp.setDmfTemplate(new StringTemplate(((DLIResolverSerializer)serializer).getDmfTemplate().getTemplate()));
        tmp.setScholixTemplate(new StringTemplate(((DLIResolverSerializer)serializer).getScholixTemplate().getTemplate()));
        this.serializer = tmp;
    }
}

