/**
 *
 */
package eu.dnetlib.dli.resolver;

import com.google.common.collect.Lists;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;

import eu.dnetlib.pid.resolver.model.ObjectType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Scanner;

/**
 * @author sandro
 */
public class ANDSResolver extends DLIPIDResolver {

	private static final String url = "http://researchdata.ands.org.au/registry/registry_object/exportToEndnote/%s.ris";
	private static final Log log = LogFactory.getLog(ANDSResolver.class);

	private static final String ANDS_NS_PREFIX = "r3d100010464";
	private static final String ANDS_EXPECTED_TYPE = "url";


    @Override
	protected boolean canResolvePid(final String pidType) {
		if (log.isDebugEnabled()) {
            log.debug(String.format("Request resolve pidType :%s", pidType));
        }
		return (pidType != null && pidType.trim().toLowerCase().equals(ANDS_EXPECTED_TYPE));
	}

	@Override
    protected DLIResolvedObject resolve(final String pid, final String pidType) {
        if (!pid.contains("https://researchdata.ands.org.au/registry/registry_object/view/")) {
			if (log.isDebugEnabled()) {
				log.debug(String.format("the Pid:%s of type:%s cannot be resolved by ANDSDataciteResolver", pid, pidType));
			}
			return null;
		}
		String[] splitted = pid.split("/");
		if (splitted == null || splitted.length == 0) return null;
		final String identifier = splitted[splitted.length - 1];
		try {
			final String myString = requestURL(String.format(url, identifier));
			log.debug("Found object " + myString);
			Scanner scanner = new Scanner(myString);
            DLIResolvedObject object = new DLIResolvedObject();
            object.setCompletionStatus(CompletionStatus.complete.toString());
			object.setPid(pid);
			object.setPidType(pidType);
            DLIObjectProvenance provenance = new DLIObjectProvenance();
            setDatasourceProvenance(provenance, ANDS_NS_PREFIX);
            object.setDatasourceProvenance(Lists.newArrayList(provenance));
			object.fixContribution(provenance);
			object.setType(ObjectType.dataset);
			object.setCompletionStatus(CompletionStatus.complete.toString());
			object.setDatasourceProvenance(Lists.newArrayList(provenance));
			final List<String> authors = Lists.newArrayList();
			final List<String> titles = Lists.newArrayList();
			String date = null;
			while (scanner.hasNextLine()) {
				String line = scanner.nextLine();
				if (line.contains("AU  -")) {
					authors.add(line.replace("AU  -", ""));
				}

				if (line.contains("TI  -")) {
					titles.add(line.replace("TI  -", ""));
				}

				if (line.contains("Y2  -")) {
					date = line.replace("Y2  -", "");
				}
			}
			object.setAuthors(authors);
			object.setTitles(titles);
			object.setCompletionStatus(CompletionStatus.complete.toString());
			object.setDate(date);
			scanner.close();
			return object;
		} catch (Throwable e) {
			log.error(String.format("Error on resolving %s of type %s", pid, pidType));
			return null;
		}
	}

}
