package eu.dnetlib.dli.resolver;

import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.net.URL;

/**
 * Created by sandro on 3/6/17.
 */
public class ENAResolver extends AbstractPIDResolver {

    final static String link = "http://www.ebi.ac.uk/ena/data/view/%s&display=xml&download=xml&filename=%s.xml";
    private static final Log log = LogFactory.getLog(ENAResolver.class);

    @Override
    protected boolean canResolvePid(String pidType) {
        return pidType != null && (pidType.toLowerCase().trim().equals("ena") || pidType.toLowerCase().trim().equals("genbank"));
    }

    @Override
    protected DLIResolvedObject resolve(String pid, String pidType) {
        if (canResolvePid(pidType)) {
            try {
                final String xmlInput =  requestURL(String.format(link, pid, pid));
                return new ENAParser().parser(xmlInput, pid, pidType);

            } catch (Throwable e) {
                log.debug(String.format("Error on resolving pid: %s pidType: %s ", pid, pidType), e);
                return null;
            }
        }

        return null;
    }
}
