package eu.dnetlib.dli.resolver;

import java.util.List;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;

import eu.dnetlib.pid.resolver.model.ObjectType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by sandro on 9/26/16.
 */
public class NCBINParser {

	private static final Log log = LogFactory.getLog(NCBINParser.class);

    public DLIResolvedObject parseRecord(final String record) {
        try {
			if (record == null || record.contains("ERROR"))
				return null;

            final DLIResolvedObject parsedObject = new DLIResolvedObject();
            final VTDGen vg = new VTDGen();
			vg.setDoc(record.getBytes());
			vg.parse(true);
			final VTDNav vn = vg.getNav();
			final AutoPilot ap = new AutoPilot(vn);
			parsedObject.setTitles(VtdUtilityParser.getTextValue(ap, vn, "//Item[./@Name='Title']"));
			List<String> dates = VtdUtilityParser.getTextValue(ap, vn, "//Item[./@Name='CreateDate']");
			if(dates!=null && dates.size()>0)
				parsedObject.setDate(dates.get(0));

			parsedObject.setType(ObjectType.dataset);
			return parsedObject;
		} catch (Throwable e) {
			log.error(String.format("Error on parsing document %s", record), e);
			return null;
		}
	}

}
