/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.collector.plugin;

import eu.dnetlib.dli.collector.plugin.ScholixIterator;
import eu.dnetlib.dli.resolver.model.serializer.DLIResolverSerializer;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import eu.dnetlib.rmi.data.plugin.CollectorPlugin;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ScholixFromFSCollectorPlugin
extends AbstractCollectorPlugin
implements CollectorPlugin {
    private static final Log log = LogFactory.getLog(ScholixFromFSCollectorPlugin.class);
    @Autowired
    private DLIResolverSerializer serializer;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        try {
            String baseUrl = interfaceDescriptor.getBaseUrl();
            Path dir = FileSystems.getDefault().getPath(baseUrl, new String[0]);
            DirectoryStream<Path> pathIterator = Files.newDirectoryStream(dir, "*json");
            return () -> new ScholixIterator(pathIterator, this.serializer);
        }
        catch (Throwable e) {
            throw new CollectorServiceException(e);
        }
    }

    public DLIResolverSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(DLIResolverSerializer serializer) {
        this.serializer = serializer;
    }
}

