/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.parser;

import com.google.common.collect.Lists;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIObjectRelation;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.dli.resolver.model.ObjectProvisionMode;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DLIRecordParser {
    private static final Log log = LogFactory.getLog(DLIRecordParser.class);

    public DLIResolvedObject parseRecord(String record) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(new ByteArrayInputStream(record.getBytes()));
            DLIResolvedObject object = new DLIResolvedObject();
            Stack<String> elementStack = new Stack<String>();
            elementStack.push("/");
            ArrayList titles = Lists.newArrayList();
            ArrayList authors = Lists.newArrayList();
            List relatedAuthors = null;
            boolean insideRelation = false;
            DLIObjectRelation currentRelation = null;
            DLIResolvedObject currentExtraInfo = null;
            ArrayList relations = Lists.newArrayList();
            ArrayList datasources = Lists.newArrayList();
            while (parser.hasNext()) {
                int i;
                String localName;
                int event = parser.next();
                if (event == 2) {
                    localName = parser.getLocalName();
                    if (localName.equals("relatedauthors") && currentExtraInfo != null && relatedAuthors != null) {
                        currentExtraInfo.setAuthors(relatedAuthors);
                        relatedAuthors.clear();
                        relatedAuthors = null;
                    }
                    if (localName.equals("relation")) {
                        log.debug((Object)"found closed tag relation");
                        insideRelation = false;
                        if (currentRelation != null) {
                            if (currentExtraInfo != null) {
                                currentExtraInfo.setPid(currentRelation.getTargetPID().getId());
                                currentExtraInfo.setPidType(currentRelation.getTargetPID().getType());
                                currentExtraInfo.setDatasourceProvenance(object.getDatasourceProvenance());
                                currentRelation.setExtraInfo(currentExtraInfo);
                            }
                            if (object.getPid() == null || object.getPid().isEmpty()) {
                                log.error((Object)"ERROR the DOI is empty");
                            }
                            currentRelation.setSourcePid(object.getPid());
                            if (!StringUtils.isBlank((CharSequence)object.getPid()) && !StringUtils.isBlank((CharSequence)object.getPidType())) {
                                currentRelation.setSourceRecordId(object.getIdentifier());
                            }
                            log.debug((Object)"Adding new relation to the object");
                            relations.add(currentRelation);
                            currentRelation = null;
                        }
                    }
                    elementStack.pop();
                    continue;
                }
                if (event != 1) continue;
                localName = parser.getLocalName();
                elementStack.push(localName);
                if ("localIdentifier".equals(localName)) {
                    log.debug((Object)"found open tag localIdentifier");
                    String type = "";
                    for (i = 0; i < parser.getAttributeCount(); ++i) {
                        if (!parser.getAttributeLocalName(i).equals("type")) continue;
                        type = parser.getAttributeValue(i);
                        break;
                    }
                    parser.next();
                    if (!parser.hasText()) continue;
                    object.setPid(parser.getText().trim());
                    object.setPidType(type);
                    continue;
                }
                if ("title".equals(localName)) {
                    log.debug((Object)"found open tag title");
                    parser.next();
                    if (!parser.hasText()) continue;
                    titles.add(parser.getText().trim());
                    continue;
                }
                if ("datasource".equals(localName)) {
                    String completionStatus = "";
                    String provisionMode = "";
                    log.debug((Object)"found open tag datasources");
                    for (int i2 = 0; i2 < parser.getAttributeCount(); ++i2) {
                        if (parser.getAttributeLocalName(i2).equals("completionStatus")) {
                            completionStatus = parser.getAttributeValue(i2);
                            continue;
                        }
                        if (!parser.getAttributeLocalName(i2).equals("provisionMode")) continue;
                        provisionMode = parser.getAttributeValue(i2);
                    }
                    parser.next();
                    if (!parser.hasText()) continue;
                    String dt = parser.getText().trim();
                    DLIObjectProvenance pr = new DLIObjectProvenance(dt, ObjectProvisionMode.fromString((String)provisionMode).toString(), CompletionStatus.fromString((String)completionStatus).toString(), null, null, true);
                    datasources.add(pr);
                    continue;
                }
                if ("completionStatus".equals(localName)) {
                    log.debug((Object)"found open tag completionStatus");
                    parser.next();
                    if (!parser.hasText()) continue;
                    object.setCompletionStatus(CompletionStatus.fromString((String)parser.getText().trim()).toString());
                    continue;
                }
                if ("fullname".equals(localName)) {
                    log.debug((Object)"found open tag fullname");
                    parser.next();
                    if (!parser.hasText()) continue;
                    authors.add(parser.getText().trim());
                    continue;
                }
                if ("relation".equals(localName)) {
                    log.debug((Object)"found open tag relation");
                    insideRelation = true;
                    currentRelation = new DLIObjectRelation();
                    currentExtraInfo = new DLIResolvedObject();
                    continue;
                }
                if ("pid".equals(localName) && insideRelation) {
                    PID currentPid = new PID();
                    for (i = 0; i < parser.getAttributeCount(); ++i) {
                        if (!parser.getAttributeLocalName(i).equals("type")) continue;
                        currentPid.setType(parser.getAttributeValue(i));
                        break;
                    }
                    try {
                        parser.next();
                        if (!parser.hasText()) continue;
                        currentPid.setId(parser.getText().trim());
                        currentRelation.setTargetPID(currentPid);
                    }
                    catch (Exception e) {
                        log.error((Object)"skipped doi");
                    }
                    continue;
                }
                if ("typeOfRelation".equals(localName) && insideRelation) {
                    log.debug((Object)"found open tag typeOfRelation");
                    parser.next();
                    if (!parser.hasText()) continue;
                    currentRelation.setRelationSemantics(parser.getText().trim());
                    continue;
                }
                if ("relatedtype".equals(localName) && insideRelation) {
                    log.debug((Object)"found open tag relatedtype");
                    parser.next();
                    if (!parser.hasText()) continue;
                    currentExtraInfo.setType(ObjectType.valueOf((String)parser.getText().trim()));
                    continue;
                }
                if ("relatedtitle".equals(localName) && insideRelation) {
                    log.debug((Object)"found open tag relatedtype");
                    parser.next();
                    if (!parser.hasText()) continue;
                    currentExtraInfo.setTitles((List)Lists.newArrayList((Object[])new String[]{parser.getText().trim()}));
                    continue;
                }
                if ("relatedauthor".equals(localName) && insideRelation) {
                    log.debug((Object)"found open tag relatedtype");
                    parser.next();
                    if (!parser.hasText()) continue;
                    if (relatedAuthors == null) {
                        relatedAuthors = Lists.newArrayList();
                    }
                    relatedAuthors.add(parser.getText().trim());
                    continue;
                }
                if ("objectType".equals(localName)) {
                    log.debug((Object)"found open tag objectType");
                    parser.next();
                    if (!parser.hasText()) continue;
                    object.setType(ObjectType.valueOf((String)parser.getText().trim()));
                    continue;
                }
                if (!"date".equals(localName)) continue;
                log.debug((Object)"found open tag date");
                parser.next();
                if (!parser.hasText()) continue;
                object.setDate(parser.getText().trim());
            }
            object.setAuthors((List)authors);
            object.setTitles((List)titles);
            object.setDatasourceProvenance((List)datasources);
            object.setRelations((List)relations);
            return object;
        }
        catch (Exception e) {
            log.error((Object)("Error on parsing record" + record), (Throwable)e);
            return null;
        }
    }
}

