/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.resolver.parser;

import com.google.common.collect.Lists;
import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.dli.DLIUtils;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIObjectRelation;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.dli.resolver.model.OAFHostedBy;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.parser.AbstractResolverParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DMFResolverParser
extends AbstractResolverParser {
    private static final Log log = LogFactory.getLog(DMFResolverParser.class);

    public DLIResolvedObject parseObject(String record) {
        try {
            List dates;
            String type;
            List resourceTypeGeneral;
            List titles;
            List hostedBy;
            List relations;
            DLIResolvedObject parsedObject = new DLIResolvedObject();
            VTDGen vg = new VTDGen();
            vg.setDoc(record.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            String resolvedDate = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resolvedDate']");
            parsedObject.setResolvedDate(resolvedDate);
            String datasourcePrefix = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='datasourceprefix']");
            String completionStatus = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='completionStatus']");
            String provisionMode = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='provisionMode']");
            String publisher = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='publisher']");
            DLIObjectProvenance provenance = new DLIObjectProvenance();
            provenance.setDatasourceId(DLIUtils.getIdFromDataSourcePrefix((String)datasourcePrefix));
            provenance.setDatasource(DLIUtils.getNameFromDataSourcePrefix((String)datasourcePrefix));
            provenance.setCompletionStatus(completionStatus);
            if (!StringUtils.isEmpty((CharSequence)publisher)) {
                provenance.setPublisher(publisher);
            }
            provenance.setProvisionMode(provisionMode);
            parsedObject.setDatasourceProvenance((List)Lists.newArrayList((Object[])new ObjectProvenance[]{provenance}));
            List identifierType = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='identifier']", (List)Lists.newArrayList((Object[])new String[]{"identifierType"}));
            if (this.extractIdentifier((ResolvedObject)parsedObject, identifierType)) {
                return null;
            }
            List descs = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='description']");
            if (descs != null && descs.size() > 0) {
                parsedObject.setDescription((String)descs.get(0));
            }
            if ((relations = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='relatedIdentifier']", Arrays.asList("relatedIdentifierType", "relationType", "inverseRelationType", "entityType"))) != null && relations.size() > 0) {
                ArrayList relationsResult = new ArrayList();
                relations.forEach(relationMap -> {
                    String relationType = (String)relationMap.getAttributes().get("relationType");
                    String inverseRelationType = (String)relationMap.getAttributes().get("inverseRelationType");
                    String relatedIdentifierType = (String)relationMap.getAttributes().get("relatedIdentifierType");
                    String relatedEntityType = (String)relationMap.getAttributes().get("entityType");
                    String relatedPid = relationMap.getTextValue();
                    DLIObjectRelation currentRelation = new DLIObjectRelation();
                    if (relatedEntityType == null) {
                        currentRelation.setTargetType(ObjectType.unknown);
                    } else {
                        currentRelation.setTargetType(ObjectType.valueOf((String)relatedEntityType));
                    }
                    currentRelation.setTargetPID(new PID(relatedPid, relatedIdentifierType));
                    currentRelation.setRelationSemantics(relationType);
                    currentRelation.setInverseRelation(inverseRelationType);
                    currentRelation.setCompletionStatus(CompletionStatus.incomplete.toString());
                    if (!StringUtils.isBlank((CharSequence)currentRelation.getTargetPID().getId())) {
                        relationsResult.add(currentRelation);
                    }
                });
                parsedObject.setRelations(relationsResult);
            }
            if ((hostedBy = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='hostedBy']", Arrays.asList("id", "name"))) != null) {
                hostedBy.stream().map(it -> new OAFHostedBy((String)it.getAttributes().get("id"), (String)it.getAttributes().get("name"))).forEach(arg_0 -> ((DLIResolvedObject)parsedObject).setHostedBy(arg_0));
            }
            List subjects = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='subject']", Arrays.asList("subjectScheme"));
            this.extractSubject((ResolvedObject)parsedObject, subjects);
            parsedObject.setCompletionStatus(completionStatus);
            List creators = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='creator']/*[local-name()='creatorName']");
            if (creators != null && creators.size() > 0) {
                parsedObject.setAuthors(creators);
            }
            if ((titles = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='title']")) != null && titles.size() > 0) {
                parsedObject.setTitles(titles);
            }
            if ((resourceTypeGeneral = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='resourceType']", Arrays.asList("resourceTypeGeneral"))) != null && !resourceTypeGeneral.isEmpty()) {
                type = (String)((VtdUtilityParser.Node)resourceTypeGeneral.get(0)).getAttributes().get("resourceTypeGeneral");
                this.setType((ResolvedObject)parsedObject, type);
            }
            if (parsedObject.getType() == ObjectType.unknown) {
                type = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='resourceType']");
                this.setType((ResolvedObject)parsedObject, type);
            }
            if ((dates = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='dates']/*[local-name()='date']")) != null && dates.size() > 0) {
                parsedObject.setDate((String)dates.get(0));
            }
            return parsedObject;
        }
        catch (Throwable e) {
            log.error((Object)("Error on parsing record " + record), e);
            return null;
        }
    }
}

