/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.efg.backlinks;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import eu.dnetlib.data.mdstore.modular.action.DoneCallback;
import eu.dnetlib.data.mdstore.modular.mongodb.MDStoreTransactionManagerImpl;
import eu.dnetlib.efg.backlinks.BacklinkTypeMatcher;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MongoBuildBacklinks {
    private static final Log log = LogFactory.getLog(MongoBuildBacklinks.class);
    private final int queueSize = 80;
    private final int cpus = Runtime.getRuntime().availableProcessors();
    private final ThreadLocal<XMLInputFactory> factory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLInputFactory.newInstance();
        }
    };
    private final ThreadLocal<XMLOutputFactory> outputFactory = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            return XMLOutputFactory.newInstance();
        }
    };
    private final ThreadLocal<Transformer> serializer = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                Transformer trans = factory.newTransformer();
                trans.setOutputProperty("omit-xml-declaration", "yes");
                return trans;
            }
            catch (TransformerConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    private final ThreadLocal<DocumentBuilder> docBuilder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            try {
                return dbfac.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    public UpdateOperation sentinel = new UpdateOperation(null, null);
    @Autowired
    private MDStoreTransactionManagerImpl transactionManager;
    private BacklinkTypeMatcher backlinkTypeMatcher;
    private int MAX_NUMBER_OF_RELS = 1000;
    private List<String> relationTypes = new ArrayList<String>();
    private Resource fixLinksXslt;
    private StringTemplate backlinkTemplate;
    private Set<String> entityTypes;
    private List<String> titleTypes;

    public void process(String mdId, DoneCallback doneCallback) throws MDStoreServiceException {
        try {
            log.debug((Object)("generating backlink for mdstore ID:" + mdId));
            ThreadPoolExecutor executor = this.createExecutor();
            String internalId = this.transactionManager.readMdStore(mdId);
            MongoDatabase db = this.transactionManager.getDb();
            MongoCollection backlinks = db.getCollection(internalId + "backlinks", DBObject.class);
            backlinks.deleteMany((Bson)new BasicDBObject());
            ArrayBlockingQueue<UpdateOperation> emitQueue = new ArrayBlockingQueue<UpdateOperation>(500);
            MongoCollection data = db.getCollection(internalId, DBObject.class);
            long size = data.count();
            double currentPosition = 0.0;
            backlinks.drop();
            backlinks.createIndex((Bson)new BasicDBObject("id", (Object)1));
            data.createIndex((Bson)new BasicDBObject("id", (Object)1));
            data.createIndex((Bson)new BasicDBObject("originalId", (Object)1));
            log.info((Object)"start background updating thread");
            Thread backgroundUpdating = this.startBackgroundUpdating(emitQueue, (MongoCollection<DBObject>)backlinks);
            log.debug((Object)"start parsing links");
            currentPosition = this.parseLinks(currentPosition, executor, (MongoCollection<DBObject>)data, emitQueue);
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.MINUTES);
            log.debug((Object)("finish parallel part: grouping " + executor.isShutdown()));
            emitQueue.put(this.sentinel);
            backgroundUpdating.join();
            log.debug((Object)"finish background backlinks storing");
            executor = this.createExecutor();
            log.debug((Object)("new executor " + executor.isShutdown()));
            this.fixLinks((MongoCollection<DBObject>)data, size, (MongoCollection<DBObject>)backlinks, executor, currentPosition);
            log.debug((Object)"waiting for other executor");
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.MINUTES);
            log.debug((Object)"finish parallel part: fixing");
            backlinks.createIndex((Bson)new BasicDBObject("id", (Object)1));
            data.createIndex((Bson)new BasicDBObject("id", (Object)1));
            data.createIndex((Bson)new BasicDBObject("originalId", (Object)1));
            HashMap paramsOut = new HashMap();
            doneCallback.call(paramsOut);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private void fixLinks(MongoCollection<DBObject> data, long size, MongoCollection<DBObject> backlinks, ThreadPoolExecutor executor, double currentPosition) {
        double step = 1.0 * (double)size / (double)backlinks.count();
        log.debug((Object)"FIXLINKS");
        for (DBObject link : backlinks.find()) {
            log.debug((Object)("FIXING LINK " + link));
            try {
                executor.submit(() -> {
                    try {
                        List links = (List)link.get("links");
                        this.fixLinks(data, (String)link.get("id"), links);
                    }
                    catch (Throwable e) {
                        log.warn((Object)"problems fixing", e);
                    }
                });
                currentPosition += step;
            }
            catch (Throwable e) {
                log.warn((Object)"problems fixing", e);
            }
        }
        log.debug((Object)"FINISH FIXLINKS");
    }

    private double parseLinks(double currentPosition, ThreadPoolExecutor executor, MongoCollection<DBObject> data, BlockingQueue<UpdateOperation> emitQueue) {
        for (DBObject current : data.find()) {
            try {
                executor.submit(() -> this.parseLinks((String)current.get("body"), emitQueue));
                currentPosition += 1.0;
            }
            catch (Throwable e) {
                log.warn((Object)"problems parsing", e);
            }
        }
        return currentPosition;
    }

    private Thread startBackgroundUpdating(BlockingQueue<UpdateOperation> queue, MongoCollection<DBObject> coll) {
        Thread background = new Thread(() -> {
            try {
                UpdateOperation record;
                while ((record = (UpdateOperation)queue.take()) != this.sentinel) {
                    UpdateOptions op = new UpdateOptions();
                    op.upsert(true);
                    coll.updateOne((Bson)record.find, (Bson)record.update, op);
                }
            }
            catch (InterruptedException e) {
                log.fatal((Object)"got exception in background thread", (Throwable)e);
                throw new IllegalStateException(e);
            }
        });
        background.start();
        return background;
    }

    protected ThreadPoolExecutor createExecutor() {
        return new ThreadPoolExecutor(this.cpus, this.cpus, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(80, true), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private void fixLinks(MongoCollection<DBObject> collection, String id, List<DBObject> links) {
        Bson query = Filters.eq((String)"originalId", (Object)id);
        BasicDBObject source = (BasicDBObject)collection.find(query).first();
        if (source == null) {
            log.warn((Object)("object with originalId " + id + " doesn't exist or doesn't belong to this collection"));
            return;
        }
        String origBody = (String)source.get("body");
        log.debug((Object)("UPDATING LINKS " + id));
        String updated = this.updateLinks(id, origBody, links);
        if (!origBody.equalsIgnoreCase(updated)) {
            collection.updateOne(query, (Bson)new BasicDBObject("$set", (Object)new BasicDBObject("body", (Object)updated)));
        }
    }

    public boolean isEfgEntity(StartElement element) {
        return this.isEfgEntity(element.getName());
    }

    public boolean isEfgEntity(EndElement element) {
        return this.isEfgEntity(element.getName());
    }

    public boolean isEfgEntity(QName name) {
        return this.entityTypes.contains(name.getLocalPart());
    }

    public boolean isRelation(XMLEvent event) {
        if (event.isStartElement()) {
            return this.isRelation(event.asStartElement());
        }
        return false;
    }

    public boolean isEndRelation(XMLEvent event) {
        if (event.isEndElement()) {
            return this.isRelation(event.asEndElement());
        }
        return false;
    }

    public boolean isRelation(StartElement element) {
        return this.isRelation(element.getName());
    }

    public boolean isRelation(EndElement element) {
        return this.isRelation(element.getName());
    }

    public boolean isRelation(QName name) {
        return name.getLocalPart().startsWith("rel");
    }

    public XMLEventReader fragment(String source) throws XMLStreamException {
        return this.fragment(this.factory.get().createXMLEventReader(new StringReader(source)));
    }

    public XMLEventReader fragment(XMLEventReader reader) throws XMLStreamException {
        return this.factory.get().createFilteredReader(reader, new EventFilter(){

            @Override
            public boolean accept(XMLEvent evt) {
                return !evt.isStartDocument() && !evt.isEndDocument();
            }
        });
    }

    public String linkToFragment(DBObject link) {
        StringTemplate template = new StringTemplate(this.backlinkTemplate.getTemplate());
        template.setAttribute("relType", this.prepareValueForTemplate(link.get("type")));
        template.setAttribute("targetId", this.prepareValueForTemplate(link.get("target")));
        template.setAttribute("title", this.prepareValueForTemplate(link.get("title")));
        template.setAttribute("name", this.prepareValueForTemplate(link.get("name")));
        template.setAttribute("type", this.prepareValueForTemplate(this.backlinkTypeMatcher.getInverseType(link.get("elementType").toString())));
        template.setAttribute("itemTypes", this.prepareValueForTemplate(link.get("itemTypes")));
        String res = template.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("UPDATING adding link: " + res.replaceAll("\n", "")));
        }
        return res;
    }

    private Object prepareValueForTemplate(Object obj) {
        if (obj != null && obj instanceof String) {
            return StringEscapeUtils.escapeXml11((String)obj.toString());
        }
        return obj;
    }

    private String maybeIdentifier(XMLEventReader reader, XMLEventWriter writer, XMLEvent event) throws XMLStreamException {
        XMLEvent next;
        if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equalsIgnoreCase("identifier") && (next = reader.peek()).isCharacters()) {
            return next.asCharacters().getData().trim();
        }
        return null;
    }

    public DBObject findLink(String currentRelId, List<DBObject> links) {
        for (DBObject link : links) {
            if (!link.get("target").equals(currentRelId)) continue;
            return link;
        }
        return null;
    }

    public String updateLinks(String id, String body, List<DBObject> links) {
        log.debug((Object)("UPDATING links " + id));
        try {
            StringWriter res = new StringWriter();
            XMLEventReader reader = this.factory.get().createXMLEventReader(new StringReader(body));
            XMLEventWriter writer = this.outputFactory.get().createXMLEventWriter(res);
            HashSet<String> present = new HashSet<String>();
            boolean inRelation = false;
            boolean hasItemType = false;
            String currentRelId = null;
            XMLEvent event = null;
            while (!(event = reader.nextEvent()).isEndDocument()) {
                EndElement end;
                if (this.isRelation(event)) {
                    inRelation = true;
                    currentRelId = null;
                } else if (this.isEndRelation(event)) {
                    Object itemTypes;
                    DBObject obj;
                    inRelation = false;
                    if (!hasItemType && (obj = this.findLink(currentRelId, links)) != null && (itemTypes = obj.get("itemTypes")) != null) {
                        for (String itemType : (List)itemTypes) {
                            writer.add(this.fragment("<efg:itemType xmlns:efg=\"http://www.europeanfilmgateway.eu/efg\" generated=\"true\">" + itemType + "</efg:itemType>"));
                        }
                    }
                }
                if (inRelation) {
                    String relId = this.maybeIdentifier(reader, writer, event);
                    if (relId != null) {
                        currentRelId = relId;
                        present.add(relId);
                    }
                    if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equalsIgnoreCase("itemType")) {
                        hasItemType = true;
                    }
                }
                if (event.isEndElement() && this.isEfgEntity(end = event.asEndElement())) {
                    log.debug((Object)"UPDATING end element is efgEntity");
                    for (int i = 0; i < Math.min(links.size(), this.MAX_NUMBER_OF_RELS); ++i) {
                        DBObject link = links.get(i);
                        if (present.contains(link.get("target"))) continue;
                        writer.add(this.fragment(this.linkToFragment(link)));
                    }
                }
                writer.add(event);
            }
            writer.close();
            return res.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected Document createLinksParams(List<DBObject> links) throws ParserConfigurationException {
        Document doc = this.docBuilder.get().newDocument();
        this.createLinksParams(links, doc);
        return doc;
    }

    protected Document createLinksParams(List<DBObject> links, Document doc) throws ParserConfigurationException {
        return this.createLinksParams(links, doc, doc);
    }

    protected Document createLinksParams(List<DBObject> links, Document doc, Node container) throws ParserConfigurationException {
        Element root = doc.createElement("links");
        container.appendChild(root);
        for (DBObject link : links) {
            Element node = doc.createElement("link");
            node.setAttribute("target", (String)link.get("target"));
            node.setAttribute("type", (String)link.get("type"));
            Arrays.asList("name", "title").stream().filter(attr -> link.get(attr) != null).forEach(attr -> node.setAttribute((String)attr, (String)link.get(attr)));
            root.appendChild(node);
        }
        return doc;
    }

    protected String serialize(Node doc) {
        try {
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            this.serializer.get().transform(source, result);
            return sw.toString();
        }
        catch (TransformerException e) {
            log.warn((Object)"cannot serialize", (Throwable)e);
            return "";
        }
    }

    public boolean moreSpecific(String next, String old, List<String> categories) {
        if (old == null) {
            return true;
        }
        if (next == null) {
            return false;
        }
        return categories.indexOf(next.toLowerCase()) > categories.indexOf(old.toLowerCase());
    }

    private void parseLinks(String record, BlockingQueue<UpdateOperation> emitQueue) {
        String recordId = null;
        String recordType = null;
        String relType = null;
        ArrayList<ToEmit> toEmit = new ArrayList<ToEmit>();
        HashMap<String, String> params = new HashMap<String, String>();
        String firstName = null;
        String lastName = "";
        String title = null;
        String titleType = null;
        Stack<String> elementStack = new Stack<String>();
        elementStack.push("/");
        try {
            XMLStreamReader parser = this.factory.get().createXMLStreamReader(new StreamSource(new StringReader(record)));
            block2: while (parser.hasNext()) {
                String localName;
                int event;
                block21: {
                    block23: {
                        String value;
                        String part;
                        block25: {
                            block24: {
                                block22: {
                                    block20: {
                                        event = parser.next();
                                        if (event == 2) {
                                            this.pop(elementStack);
                                            continue;
                                        }
                                        if (event != 1) continue;
                                        localName = parser.getLocalName();
                                        this.push(elementStack, localName);
                                        if ("efgEntity".equalsIgnoreCase(localName)) {
                                            while (parser.hasNext()) {
                                                event = parser.next();
                                                if (event != 1) continue;
                                                recordType = parser.getLocalName();
                                                relType = this.normalizeRecordType(recordType);
                                                this.push(elementStack, recordType);
                                                break;
                                            }
                                        }
                                        if (!"identifier".equalsIgnoreCase(localName) || !"efgEntity".equalsIgnoreCase(this.grandParent(elementStack))) break block20;
                                        parser.next();
                                        recordId = parser.getText();
                                        break block21;
                                    }
                                    if (!"identifier".equalsIgnoreCase(localName)) break block22;
                                    parser.next();
                                    break block21;
                                }
                                if (!"person".equalsIgnoreCase(recordType)) break block23;
                                if (!"name".equalsIgnoreCase(localName)) break block21;
                                part = parser.getAttributeValue(null, "part");
                                parser.next();
                                value = parser.getText();
                                if (value != null) {
                                    value = value.trim();
                                }
                                if (!"forename".equalsIgnoreCase(part) && !"Forename(s)".equalsIgnoreCase(part)) break block24;
                                firstName = value;
                                break block21;
                            }
                            if (!"surname".equalsIgnoreCase(part) && !"Family Name".equalsIgnoreCase(part)) break block25;
                            lastName = value;
                            break block21;
                        }
                        if (!"stem".equalsIgnoreCase(part)) break block21;
                        lastName = value;
                        break block21;
                    }
                    if (this.isCreation(recordType) && "title".equalsIgnoreCase(localName)) {
                        String tmpTitle = null;
                        String tmpType = null;
                        while (parser.hasNext()) {
                            event = parser.next();
                            if (event == 1) {
                                this.push(elementStack, parser.getLocalName());
                                if ("text".equalsIgnoreCase(parser.getLocalName())) {
                                    event = parser.next();
                                    if (event != 4) continue;
                                    tmpTitle = parser.getText();
                                    continue;
                                }
                                if (!"relation".equalsIgnoreCase(parser.getLocalName()) || (event = parser.next()) != 4) continue;
                                tmpType = parser.getText();
                                continue;
                            }
                            if (event != 2) continue;
                            this.pop(elementStack);
                            if (!"title".equalsIgnoreCase(parser.getLocalName())) continue;
                            tmpType = tmpType == null ? "n/a" : tmpType.trim();
                            String string = tmpTitle = tmpTitle == null ? "n/a" : tmpTitle.trim();
                            if (!this.moreSpecific(tmpType, titleType, this.titleTypes)) break;
                            title = tmpTitle;
                            titleType = tmpType;
                            break;
                        }
                    }
                }
                if (!this.relationTypes.contains(localName)) continue;
                ToEmit nextEmission = null;
                while (parser.hasNext()) {
                    event = parser.next();
                    if (event == 1) {
                        this.push(elementStack, parser.getLocalName());
                        if ("identifier".equalsIgnoreCase(parser.getLocalName())) {
                            parser.next();
                            nextEmission = new ToEmit(parser.getText().trim(), "n/a");
                            continue;
                        }
                        if (!"type".equalsIgnoreCase(parser.getLocalName())) continue;
                        parser.next();
                        nextEmission.setElementType(parser.getText().trim());
                        toEmit.add(nextEmission);
                        continue block2;
                    }
                    if (event != 2) continue;
                    this.pop(elementStack);
                }
            }
            if ("person".equalsIgnoreCase(recordType)) {
                String personName = lastName;
                if (firstName != null) {
                    personName = firstName + " " + lastName;
                }
                params.put("name", personName);
            } else if (this.isCreation(recordType) && title != null) {
                params.put("title", title);
            }
            if (toEmit.isEmpty() && log.isDebugEnabled()) {
                log.debug((Object)("emit queue is empty for record " + recordId.trim()));
            }
            for (ToEmit emitting : toEmit) {
                this.emitBacklink(emitQueue, emitting.targetId, recordId.trim(), relType, emitting.elementType, params);
            }
        }
        catch (XMLStreamException e) {
            log.info((Object)"some parsing exception, moving along");
        }
    }

    private String grandParent(Stack<String> elementStack) {
        if (elementStack.size() <= 3) {
            return "";
        }
        String res = (String)elementStack.get(elementStack.size() - 3);
        return res;
    }

    private void pop(Stack<String> elementStack) {
        elementStack.pop();
    }

    private void push(Stack<String> elementStack, String localName) {
        elementStack.push(localName);
    }

    private boolean isCreation(String recordType) {
        return "avcreation".equalsIgnoreCase(recordType) || "nonavcreation".equalsIgnoreCase(recordType);
    }

    private String normalizeRecordType(String localName) {
        String relName = "rel" + localName;
        for (String type : this.relationTypes) {
            if (!relName.equalsIgnoreCase(type)) continue;
            return type;
        }
        return relName;
    }

    private void emitBacklink(BlockingQueue<UpdateOperation> emitQueue, String source, String target, String targetType, String elementType, Map<String, String> params) {
        BasicDBObject pair = new BasicDBObject();
        pair.put("target", (Object)target);
        pair.put("type", (Object)targetType);
        pair.put("elementType", (Object)elementType);
        pair.putAll(params);
        BasicDBObject find = new BasicDBObject("id", (Object)source);
        BasicDBObject update = new BasicDBObject("$push", (Object)new BasicDBObject("links", (Object)pair));
        try {
            emitQueue.put(new UpdateOperation((DBObject)find, (DBObject)update));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<String> getRelationTypes() {
        return this.relationTypes;
    }

    public void setRelationTypes(List<String> relationTypes) {
        this.relationTypes = relationTypes;
    }

    public Resource getFixLinksXslt() {
        return this.fixLinksXslt;
    }

    @Required
    public void setFixLinksXslt(Resource fixLinksXslt) {
        this.fixLinksXslt = fixLinksXslt;
    }

    public StringTemplate getBacklinkTemplate() {
        return this.backlinkTemplate;
    }

    @Required
    public void setBacklinkTemplate(StringTemplate backlinkTemplate) {
        this.backlinkTemplate = backlinkTemplate;
    }

    public List<String> getTitleTypes() {
        return this.titleTypes;
    }

    public void setTitleTypes(List<String> titleTypes) {
        this.titleTypes = titleTypes;
    }

    public Set<String> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Set<String> entityTypes) {
        this.entityTypes = entityTypes;
    }

    public BacklinkTypeMatcher getBacklinkTypeMatcher() {
        return this.backlinkTypeMatcher;
    }

    @Required
    public void setBacklinkTypeMatcher(BacklinkTypeMatcher backlinkTypeMatcher) {
        this.backlinkTypeMatcher = backlinkTypeMatcher;
    }

    public int getMAX_NUMBER_OF_RELS() {
        return this.MAX_NUMBER_OF_RELS;
    }

    @Required
    public void setMAX_NUMBER_OF_RELS(int mAXNUMBEROFRELS) {
        this.MAX_NUMBER_OF_RELS = mAXNUMBEROFRELS;
    }

    static class ToEmit {
        private String targetId;
        private String elementType;

        public ToEmit(String targetId, String elementType) {
            this.targetId = targetId;
            this.elementType = elementType;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public String getElementType() {
            return this.elementType;
        }

        public void setElementType(String elementType) {
            this.elementType = elementType;
        }
    }

    public static class UpdateOperation {
        private DBObject find;
        private DBObject update;

        public UpdateOperation(DBObject find, DBObject update) {
            this.find = find;
            this.update = update;
        }

        public DBObject getFind() {
            return this.find;
        }

        public void setFind(DBObject find) {
            this.find = find;
        }

        public DBObject getUpdate() {
            return this.update;
        }

        public void setUpdate(DBObject update) {
            this.update = update;
        }
    }
}

