/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.efg.workflows.nodes.thumbnail;

import eu.dnetlib.data.objectstore.connector.ObjectStore;
import eu.dnetlib.data.objectstore.connector.ObjectStoreDao;
import eu.dnetlib.efg.workflows.nodes.thumbnail.WorkerMap;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GenerateThumbnailJobNode
extends SimpleJobNode
implements ProgressProvider {
    private static final Log log = LogFactory.getLog(GenerateThumbnailJobNode.class);
    public static ObjectStoreFile END_QUEUE = new ObjectStoreFile();
    @Autowired
    ResultSetClient resultSetClient;
    private String nativeObjectStore;
    private String storeThumb250;
    private String storeThumb96;
    private int numberOfThreads = 4;
    @Autowired
    private ObjectStoreDao objectStoreDao;
    private int counter = -1;
    private int total = -1;

    protected String execute(Env env) throws Exception {
        ObjectStore objectStore = this.objectStoreDao.getObjectStore(this.nativeObjectStore);
        this.total = objectStore.getSize();
        ObjectStore objectStore250 = this.objectStoreDao.getObjectStore((String)env.getAttribute(this.storeThumb250, String.class));
        ObjectStore objectStore96 = this.objectStoreDao.getObjectStore((String)env.getAttribute(this.storeThumb96, String.class));
        ResultSetListener deliver = objectStore.deliver(Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()));
        ArrayBlockingQueue<ObjectStoreFile> queue = new ArrayBlockingQueue<ObjectStoreFile>(10);
        ExecutorService executor = Executors.newFixedThreadPool(this.numberOfThreads);
        ArrayList<Future<Boolean>> responses = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < 4; ++i) {
            responses.add(executor.submit(new WorkerMap(objectStore, objectStore250, objectStore96, queue)));
        }
        this.counter = 0;
        while (deliver.hasNext()) {
            ++this.counter;
            queue.put((ObjectStoreFile)deliver.next());
        }
        queue.put(END_QUEUE);
        for (Future future : responses) {
            if (((Boolean)future.get()).booleanValue()) continue;
            log.error((Object)"Some response fail");
        }
        return Arc.DEFAULT_ARC;
    }

    protected void beforeStart(Token token) {
        token.setProgressProvider((ProgressProvider)this);
    }

    public String getNativeObjectStore() {
        return this.nativeObjectStore;
    }

    public void setNativeObjectStore(String nativeObjectStore) {
        this.nativeObjectStore = nativeObjectStore;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public String getStoreThumb250() {
        return this.storeThumb250;
    }

    public void setStoreThumb250(String storeThumb250) {
        this.storeThumb250 = storeThumb250;
    }

    public String getStoreThumb96() {
        return this.storeThumb96;
    }

    public void setStoreThumb96(String storeThumb96) {
        this.storeThumb96 = storeThumb96;
    }

    public String getProgressDescription() {
        return this.counter < 0 ? "-" : String.format("%d / %d", this.counter, this.total);
    }
}

