/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.efg.workflows.nodes;

import eu.dnetlib.efg.workflows.nodes.ApplyEFGPatchFunction;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreService;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dom4j.Namespace;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplyEFGPatchJobNode
extends SimpleJobNode {
    private static final Namespace EFG_NS = new Namespace("efg", "http://www.europeanfilmgateway.eu/efg");
    private String inputEprParam;
    private String outputEprParam;
    private String originalMdStoreId;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private UniqueServiceLocator locator;
    @Autowired
    private ResultSetClient resultSetClient;

    protected String execute(Env env) throws Exception {
        ResultSet rsIn = (ResultSet)env.getAttribute(this.inputEprParam, ResultSet.class);
        Iterable iter = this.resultSetClient.iter(rsIn, String.class);
        Stream stringStream = DnetStreamSupport.generateStreamFromIterator(iter.iterator());
        MDStoreService mdStoreService = (MDStoreService)this.locator.getService(MDStoreService.class);
        List collect = stringStream.map(new ApplyEFGPatchFunction(mdStoreService, this.originalMdStoreId, EFG_NS)).collect(Collectors.toList());
        ResultSet outputResultSet = this.resultSetFactory.createResultSet(collect);
        env.setAttribute(this.getOutputEprParam(), (Object)outputResultSet);
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getOriginalMdStoreId() {
        return this.originalMdStoreId;
    }

    public void setOriginalMdStoreId(String originalMdStoreId) {
        this.originalMdStoreId = originalMdStoreId;
    }
}

