<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:datetime="http://exslt.org/dates-and-times"
                xmlns:exslt="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:efg="http://www.europeanfilmgateway.eu/efg" version="1.0"
                exclude-result-prefixes="xsl datetime exslt xsi xalan">

	<!--	<xsl:param name="links" />  -->

	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/">
		<xsl:apply-templates select="*"/>
	</xsl:template>

	<xsl:template match="/record/links"/>

	<xsl:template match="efg:person|efg:avcreation|efg:nonavcreation">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()"/>

			<xsl:for-each select="/record/links/link">
				<xsl:call-template name="buildRelation">
					<xsl:with-param name="type" select="@type"/>
					<xsl:with-param name="target" select="@target"/>
					<xsl:with-param name="name" select="@name"/>
					<xsl:with-param name="title" select="@title"/>
				</xsl:call-template>
			</xsl:for-each>

		</xsl:copy>
	</xsl:template>

	<xsl:template match="*|@*|text()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template name="buildRelation">
		<xsl:param name="type"/>
		<xsl:param name="target"/>
		<xsl:param name="name"/>
		<xsl:param name="title"/>

		<xsl:if test="not(/record/metadata/efg:efgEntity/efg:*/efg:*[local-name()=$type]/efg:identifier[normalize-space(text()) = $target])">
			<xsl:element name="efg:{$type}">

				<!-- HACK michele -->
				<xsl:if test="($type = 'relAvCreation') or ($type = 'relNonAVCreation')">
					<efg:hasItems>true</efg:hasItems>
				</xsl:if>
				<!-- FINE HACK -->

				<efg:identifier>
					<xsl:value-of select="$target"/>
				</efg:identifier>
				<xsl:if test="$name">
					<efg:name>
						<xsl:value-of select="$name"/>
					</efg:name>
				</xsl:if>
				<xsl:if test="$title">
					<efg:title>
						<xsl:value-of select="$title"/>
					</efg:title>
				</xsl:if>
			</xsl:element>
		</xsl:if>

	</xsl:template>

</xsl:stylesheet>