package eu.dnetlib.efg.workflows.nodes;

import java.io.StringReader;
import java.util.function.UnaryOperator;

import eu.dnetlib.rmi.data.MDStoreService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.*;
import org.dom4j.io.SAXReader;

public class ApplyEFGPatchFunction implements UnaryOperator<String> {

	private static final Log log = LogFactory.getLog(ApplyEFGPatchFunction.class); // NOPMD by marko on 11/24/08 5:02 PM
	private MDStoreService mdstoreService;
	private String mdstoreId;
	private Namespace defaultNS;
	private SAXReader reader = new SAXReader();

	public ApplyEFGPatchFunction(MDStoreService mdstoreService, String mdstoreId, Namespace defaultNS) {
		super();
		this.mdstoreService = mdstoreService;
		this.mdstoreId = mdstoreId;
		this.defaultNS = defaultNS;
	}

	@Override
	public String apply(final String patchProfile) {
		try {
			Document patchDoc = reader.read(new StringReader(patchProfile));
			String recordID = patchDoc.valueOf("//*[local-name()='objIdentifier']");
			Document record = reader.read(new StringReader(mdstoreService.deliverRecord(mdstoreId, recordID)));

			for (Object o : patchDoc.selectNodes("//patch")) {
				String xpath = ((Element) o).valueOf("@xpath");
				String value = ((Element) o).valueOf("@value");
				PatchOperations operation = PatchOperations.valueOf(((Element) o).valueOf("@operation"));

				Node contextNode = record.selectSingleNode(xpath);
				if (contextNode != null && xpath != null && operation != null) {
					log.info("*** Patch: op=" + operation + ", value=" + value);
					switch (operation) {
					case EDIT:
						contextNode.setText(value);
						break;
					case DELETENODE:
						Node dn = contextNode.selectSingleNode("./*[local-name() = '" + value + "' ]");
						if (dn != null) {
							dn.detach();
						}
						break;
					case VERIFYNODE:
						Node vn = contextNode.selectSingleNode("./*[local-name() = '" + value + "' ]");
						if (vn == null && contextNode instanceof Element) {
							QName qname = (defaultNS != null) ? new QName(value, defaultNS) : new QName(value);
							((Element) contextNode).addElement(qname);
						}
						break;
					case VERIFYATTRIBUTE:
						String val = contextNode.valueOf("@" + value);
						if ((val == null || val.isEmpty()) && contextNode instanceof Element) {
							((Element) contextNode).addAttribute(value, "");
						}
						break;
					case ADDSUBTREE:
						for (Object ob : ((Element) o).selectNodes("./*")) {
							log.info("ADDING SUBTREE");
							Element newElem = ((Element) ob).createCopy();
							((Element) contextNode).add(newElem);
						}
					default:
						break;
					}
				} else {
					log.warn("Context Node not found: " + xpath);
				}
			}
			return record.asXML();
		} catch (Exception e) {
			log.error("Error applying patch", e);
			return "";
			//			return "<record xmlns:dri='http://www.driver-repository.eu/namespace/dri'>" + "<header>" + "<dri:objIdentifier>FAKE</dri:objIdentifier>"
			//					+ "<dri:repositoryId>FAKE</dri:repositoryId>" + "</header>" + "<metadata />" + "</record>";
		}
	}
}