package eu.dnetlib.efg.workflows.nodes;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreService;
import org.dom4j.Namespace;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by sandro on 5/13/16.
 */
public class ApplyEFGPatchJobNode extends SimpleJobNode {

	private static final Namespace EFG_NS = new Namespace("efg", "http://www.europeanfilmgateway.eu/efg");
	private String inputEprParam;
	private String outputEprParam;
	private String originalMdStoreId;
	@Autowired
	private ResultSetFactory resultSetFactory;
	@Autowired
	private UniqueServiceLocator locator;
	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	protected String execute(final Env env) throws Exception {

		final ResultSet<?> rsIn = env.getAttribute(this.inputEprParam, ResultSet.class);

		final Iterable<String> iter = this.resultSetClient.iter(rsIn, String.class);

		final Stream<String> stringStream = DnetStreamSupport.generateStreamFromIterator(iter.iterator());

		final MDStoreService mdStoreService = locator.getService(MDStoreService.class);

		final List<String> collect = stringStream.map(new ApplyEFGPatchFunction(mdStoreService, originalMdStoreId, EFG_NS)).collect(Collectors.toList());

		final ResultSet<String> outputResultSet = this.resultSetFactory.createResultSet(collect);

		env.setAttribute(getOutputEprParam(), outputResultSet);

		return Arc.DEFAULT_ARC;
	}

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getOriginalMdStoreId() {
		return originalMdStoreId;
	}

	public void setOriginalMdStoreId(final String originalMdStoreId) {
		this.originalMdStoreId = originalMdStoreId;
	}
}
