/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.efg.workflows.nodes;

import eu.dnetlib.efg.workflows.nodes.PatchOperations;
import eu.dnetlib.rmi.data.MDStoreService;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.UnaryOperator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class ApplyEFGPatchFunction
implements UnaryOperator<String> {
    private static final Log log = LogFactory.getLog(ApplyEFGPatchFunction.class);
    private MDStoreService mdstoreService;
    private String mdstoreId;
    private Namespace defaultNS;
    private SAXReader reader = new SAXReader();

    public ApplyEFGPatchFunction(MDStoreService mdstoreService, String mdstoreId, Namespace defaultNS) {
        this.mdstoreService = mdstoreService;
        this.mdstoreId = mdstoreId;
        this.defaultNS = defaultNS;
    }

    @Override
    public String apply(String patchProfile) {
        try {
            Document patchDoc = this.reader.read((Reader)new StringReader(patchProfile));
            String recordID = patchDoc.valueOf("//*[local-name()='objIdentifier']");
            Document record = this.reader.read((Reader)new StringReader(this.mdstoreService.deliverRecord(this.mdstoreId, recordID)));
            block9: for (Object o : patchDoc.selectNodes("//patch")) {
                String xpath = ((Element)o).valueOf("@xpath");
                String value = ((Element)o).valueOf("@value");
                PatchOperations operation = PatchOperations.valueOf(((Element)o).valueOf("@operation"));
                Node contextNode = record.selectSingleNode(xpath);
                if (contextNode != null && xpath != null && operation != null) {
                    log.info((Object)("*** Patch: op=" + (Object)((Object)operation) + ", value=" + value));
                    switch (operation) {
                        case EDIT: {
                            contextNode.setText(value);
                            continue block9;
                        }
                        case DELETENODE: {
                            Node dn = contextNode.selectSingleNode("./*[local-name() = '" + value + "' ]");
                            if (dn == null) continue block9;
                            dn.detach();
                            continue block9;
                        }
                        case VERIFYNODE: {
                            Node vn = contextNode.selectSingleNode("./*[local-name() = '" + value + "' ]");
                            if (vn != null || !(contextNode instanceof Element)) continue block9;
                            QName qname = this.defaultNS != null ? new QName(value, this.defaultNS) : new QName(value);
                            ((Element)contextNode).addElement(qname);
                            continue block9;
                        }
                        case VERIFYATTRIBUTE: {
                            String val = contextNode.valueOf("@" + value);
                            if (val != null && !val.isEmpty() || !(contextNode instanceof Element)) continue block9;
                            ((Element)contextNode).addAttribute(value, "");
                            continue block9;
                        }
                        case ADDSUBTREE: {
                            for (Object ob : ((Element)o).selectNodes("./*")) {
                                log.info((Object)"ADDING SUBTREE");
                                Element newElem = ((Element)ob).createCopy();
                                ((Element)contextNode).add(newElem);
                            }
                            break;
                        }
                    }
                    continue;
                }
                log.warn((Object)("Context Node not found: " + xpath));
            }
            return record.asXML();
        }
        catch (Exception e) {
            log.error((Object)"Error applying patch", (Throwable)e);
            return "";
        }
    }
}

