/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.efg.workflows.nodes.thumbnail;

import eu.dnetlib.data.objectstore.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.connector.ObjectStore;
import eu.dnetlib.efg.workflows.nodes.thumbnail.GenerateThumbnailJobNode;
import eu.dnetlib.efg.workflows.nodes.thumbnail.ThumbnailGenerator;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkerMap
implements Callable<Boolean> {
    private static final Log log = LogFactory.getLog(WorkerMap.class);
    private final ObjectStore thumb256;
    private final ObjectStore thumb96;
    private final ObjectStore nativeObjectStore;
    private final BlockingQueue<ObjectStoreFile> queue;
    private final ThumbnailGenerator thumbnailGenerator;

    public WorkerMap(ObjectStore nativeObjectStore, ObjectStore thumb256, ObjectStore thumb96, BlockingQueue<ObjectStoreFile> queue) throws IOException {
        this.thumb96 = thumb96;
        this.thumb256 = thumb256;
        this.queue = queue;
        this.nativeObjectStore = nativeObjectStore;
        this.thumbnailGenerator = new ThumbnailGenerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        ObjectStoreFile currentFile = this.queue.take();
        while (currentFile != GenerateThumbnailJobNode.END_QUEUE) {
            try {
                ObjectStoreRecord record = new ObjectStoreRecord();
                if (!this.thumb96.alreadyExist(currentFile.getObjectID())) {
                    InputStream convert = this.thumbnailGenerator.convert(this.nativeObjectStore.deliverStream(currentFile.getObjectID()), 150, 96, "96", true);
                    record.setFileMetadata(currentFile);
                    record.setInputStream(convert);
                    this.thumb96.feedObjectRecord(record);
                }
                if (this.thumb256.alreadyExist(currentFile.getObjectID())) continue;
                record.setInputStream(this.thumbnailGenerator.convert(this.nativeObjectStore.deliverStream(currentFile.getObjectID()), 600, 250, "250", false));
                this.thumb256.feedObjectRecord(record);
            }
            catch (Throwable e) {
                log.error((Object)"Error on generating thumbnail", e);
            }
            finally {
                currentFile = this.queue.take();
            }
        }
        if (currentFile == GenerateThumbnailJobNode.END_QUEUE) {
            this.queue.put(currentFile);
        }
        return true;
    }
}

