package eu.dnetlib.efg.backlinks;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyBacklinkTypeMatcherImpl implements BacklinkTypeMatcher {

	private static final Log log = LogFactory.getLog(PropertyBacklinkTypeMatcherImpl.class); // NOPMD by marko on 11/24/08 5:02 PM

	private Map<String, String> mapRules;

	public PropertyBacklinkTypeMatcherImpl(String rules) {
		super();

		this.mapRules = new HashMap<String, String>();

		for (String i : rules.split(";")) {
			String[] arr = i.split("<->");
			if (arr.length == 2) {
				String arr0 = arr[0].trim();
				String arr1 = arr[1].trim();
				mapRules.put(arr0.toLowerCase(), arr1);
				mapRules.put(arr1.toLowerCase(), arr0);
			}
		}

		for (Map.Entry<String, String> e : mapRules.entrySet()) {
			log.info("MapRules key: " + e.getKey() + " - value: " + e.getValue());
		}
	}

	@Override
	public String getInverseType(String type) {
		if (type != null && mapRules.containsKey(type.toLowerCase().trim()))
			return mapRules.get(type.toLowerCase().trim());
		return type;
	}

}
