package eu.dnetlib.efg.workflows.nodes;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by sandro on 5/26/16.
 */
public class ObtainDataSourceParamsJobNode extends SimpleJobNode {

	private String providerId;

	private String OAIformat;

	private String OAILayout;

	private String OAIInterpretation;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		final String query = "let $x := /*[.//RESOURCE_IDENTIFIER/@value='" + providerId + "']//EXTRA_FIELDS\n"
				+ "return concat($x/FIELD[./key='OpenAireDataSourceId']/value, ' @@@ ', $x/FIELD[./key='NamespacePrefix']/value)";

		final String[] arr = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(query).split("@@@");

		final String nsPrefix = arr[1].trim();
		env.setAttribute("datasource_namespacePrefix", nsPrefix);
		env.setAttribute("oai_recordSource", nsPrefix);

		env.setAttribute("OAIformat", OAIformat);
		env.setAttribute("OAILayout", OAILayout);
		env.setAttribute("OAIInterpretation", OAIInterpretation);

		return Arc.DEFAULT_ARC;
	}

	public String getProviderId() {
		return providerId;
	}

	public void setProviderId(final String providerId) {
		this.providerId = providerId;
	}

	public String getOAIformat() {
		return OAIformat;
	}

	public void setOAIformat(final String OAIformat) {
		this.OAIformat = OAIformat;
	}

	public String getOAILayout() {
		return OAILayout;
	}

	public void setOAILayout(final String OAILayout) {
		this.OAILayout = OAILayout;
	}

	public String getOAIInterpretation() {
		return OAIInterpretation;
	}

	public void setOAIInterpretation(final String OAIInterpretation) {
		this.OAIInterpretation = OAIInterpretation;
	}
}
