/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.efg.workflows.nodes.thumbnail;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.tika.Tika;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;

public class ThumbnailGenerator {
    private Path baseDirPath;
    private String dirName = UUID.randomUUID().toString();

    public ThumbnailGenerator() throws IOException {
        this.baseDirPath = Files.createTempDirectory(this.dirName, new FileAttribute[0]);
    }

    public static boolean deleteRecursive(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                ret = ret && ThumbnailGenerator.deleteRecursive(f);
            }
        }
        return ret && path.delete();
    }

    public InputStream convert(InputStream input, int width, int height, String name, boolean deleteBeforeConver) {
        try {
            this.destroyFolder();
            this.baseDirPath = Files.createTempDirectory(this.dirName, new FileAttribute[0]);
            Path tempFile = this.baseDirPath.resolve(name + "_orig");
            Files.copy(input, tempFile, StandardCopyOption.REPLACE_EXISTING);
            String inputType = this.guessMimeType(tempFile.toAbsolutePath().toString());
            String inputPath = tempFile.toAbsolutePath().toString();
            if (inputType != null && inputType.contains("pdf")) {
                inputPath = inputPath + "[0]";
            }
            ConvertCmd cmd = new ConvertCmd();
            IMOperation op = new IMOperation();
            op.addImage(new String[]{inputPath});
            op.define(String.format("jpeg:size=%dx%d", width * 2, height * 2));
            op.thumbnail(Integer.valueOf(width), Integer.valueOf(height));
            op.unsharp(Double.valueOf(0.5));
            op.background("transparent");
            op.gravity("center");
            op.extent(Integer.valueOf(width), Integer.valueOf(height));
            op.colors(Integer.valueOf(256));
            op.addImage(new String[]{tempFile.toAbsolutePath().toString().replace("orig", "conv.png")});
            cmd.run((Operation)op, new Object[0]);
            Path path = FileSystems.getDefault().getPath(tempFile.toAbsolutePath().toString().replace("orig", "conv.png"), new String[0]);
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (Throwable e) {
            System.out.println("Error on convert file" + e.toString());
            return null;
        }
    }

    private String guessMimeType(String inputPath) throws IOException {
        Tika tika = new Tika();
        return tika.detect(new File(inputPath));
    }

    public boolean destroyFolder() throws FileNotFoundException {
        return ThumbnailGenerator.deleteRecursive(this.baseDirPath.toFile());
    }
}

