<?xml version="1.0" encoding="UTF-8"?>
<RESOURCE_PROFILE>
    <HEADER>
        <RESOURCE_IDENTIFIER value=""/>
        <RESOURCE_TYPE value="WorkflowDSResourceType"/>
        <RESOURCE_KIND value="WorkflowDSResources"/>
        <RESOURCE_URI value=""/>
        <DATE_OF_CREATION value=""/>
    </HEADER>
    <BODY>
        <WORKFLOW_NAME>$name$</WORKFLOW_NAME>
        <WORKFLOW_DESCRIPTION>$desc$</WORKFLOW_DESCRIPTION>
        <WORKFLOW_INFO />
        <WORKFLOW_FAMILY>aggregator</WORKFLOW_FAMILY>
        <WORKFLOW_PRIORITY>$priority$</WORKFLOW_PRIORITY>
        <DATASOURCE id="$dsId$" interface="$interface$" />

        <CONFIGURATION status="WAIT_SYS_SETTINGS" start="MANUAL">
            <PARAMETERS>
				<PARAM name="cleanRuleId"           description="Cleaning Rule Identifier"                  required="true" managedBy="user"   category="CLEANER_RULE_ID" type="string" function="listProfiles('CleanerDSResourceType', '//CLEANER_NAME')"/>
            	<PARAM name="collMdstoreId"         description="Store for collected records"               required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="cleanMdstoreId"        description="Store for cleaned records"                 required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="edmMdstoreId"          description="Store for EDM records"                     required="true" managedBy="system" category="MDSTORE_ID"/>
                <PARAM name="edmRuleId"             description="Transformation Rule Identifier"            required="true" managedBy="user"   category="TRANSFORMATION_RULE_ID" type="string"  function="listProfiles('TransformationRuleDSResourceType', '//TITLE')" />
            	<PARAM name="nativeObjectStoreId"   description="Object Store for native images"            required="true" managedBy="system" category="OBJECTSTORE_ID"/>
            	<PARAM name="patchMdstoreId"        description="Store for patches"                         required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="indexId"               description="Identifier of the Index"                   required="true" managedBy="system" category="INDEX_ID"/>
            	<PARAM name="indexIdProduction"     description="Identifier of the Index in Production"     required="true" managedBy="system" category="INDEX_ID"/>
            	<PARAM name="indexInProduction"     description="Should Index Production?"                  required="true" managedBy="user"   function="validValues(['indexProduction', 'noIndex'])" />
            </PARAMETERS>
            <WORKFLOW>
                <NODE isStart="true" name="collection" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Collect records</DESCRIPTION>
                    <PARAMETERS>
                    	<PARAM name="wfTemplateId" value="35fc85d0-4455-42e0-85ce-7ec4e008f4d4_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                    	<PARAM name="wfTemplateParams">
                    		<MAP>
                    			<ENTRY key="dsId"          value="$dsId$" />
 								<ENTRY key="interface"     value="$interface$" />
	 							<ENTRY key="collMdstoreId" ref="collMdstoreId" />
                    		</MAP>
                    	</PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="clean"/>
                    </ARCS>
                </NODE>
                <NODE name="clean" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Clean record</DESCRIPTION>
                    <PARAMETERS>
                    	<PARAM name="wfTemplateId" value="da3531c6-2bf6-48ab-848b-bd4c6379fd65_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                    	<PARAM name="wfTemplateParams">
                    		<MAP>
                    			<ENTRY key="dsId"           value="$dsId$" />
 								<ENTRY key="interface"      value="$interface$" />
 								<ENTRY key="collMdstoreId"  ref="collMdstoreId" />
 								<ENTRY key="cleanMdstoreId" ref="cleanMdstoreId" />
 								<ENTRY key="ruleId"         ref="cleanRuleId" />
 							</MAP>
 						</PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="patch"/>
                    </ARCS>
                </NODE>
                <NODE name="patch" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Patch record</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="d8aac049-5c28-40bd-be38-fd8ae36495c2_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsId"           value="$dsId$" />
                                <ENTRY key="interface"      value="$interface$" />
                                <ENTRY key="patchMdStoreId" ref="patchMdstoreId" />
                                <ENTRY key="cleanMdstoreId" ref="cleanMdstoreId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="index"/>
                    </ARCS>
                </NODE>


                <NODE name="index" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Index record</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="8d1ea5c1-fced-4b96-b5e2-eaf5ba5b3259_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsId"           value="$dsId$" />
                                <ENTRY key="interface"      value="$interface$" />
                                <ENTRY key="cleanMdstoreId" ref="cleanMdstoreId" />
                                <ENTRY key="indexId"        ref="indexId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="indexProduction"/>
                    </ARCS>
                </NODE>



                <NODE name="indexProduction" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Index record</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="b2a8daed-ab22-4290-b5ee-85a0c7beb8bb_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsId"                     value="$dsId$" />
                                <ENTRY key="interface"                value="$interface$" />
                                <ENTRY key="cleanMdstoreId"           ref="cleanMdstoreId" />
                                <ENTRY key="indexId"                  ref="indexIdProduction" />
                                <ENTRY key="indexInProduction"        ref="indexInProduction" />

                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="oaiFeed"/>
                    </ARCS>
                </NODE>






                <NODE name="oaiFeed" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Feed oai records</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="9983e369-8110-4270-abf5-5370c7a48673_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsId"           value="$dsId$" />
                                <ENTRY key="efgMdstoreId" ref="cleanMdstoreId" />
                                <ENTRY key="edmMdstoreId"   ref="edmMdstoreId" />
                                <ENTRY key="ruleId"         ref="edmRuleId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="oaiPostFeed"/>
                    </ARCS>
                </NODE>


                <NODE name="oaiPostFeed" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Oai Post Feed Action</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="c73dd31d-17ee-4a9c-b3df-c0b278668b3d_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsId"           value="$dsId$" />
                                <ENTRY key="cleanMdstoreId" ref="cleanMdstoreId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="generateThumbnails"/>
                    </ARCS>
                </NODE>

                <NODE name="generateThumbnails" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Generate thumbnails from record</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="d12a26b0-9006-4f89-b063-9a5dc1d4b70f_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ=="/>
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsId"                          value="$dsId$" />
                                <ENTRY key="cleanMdstoreId"                ref="cleanMdstoreId" />
                                <ENTRY key="nativeObjectStoreId"           ref="nativeObjectStoreId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="success"/>
                    </ARCS>
                </NODE>






            </WORKFLOW>
            <DESTROY_WORKFLOW_TEMPLATE id="1bd0b467-e6c1-40a5-a8f4-c344e0305ef6_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==">
            	<PARAMETERS>
	            	<PARAM name="dsId"                  value="$dsId$" />
					<PARAM name="interface"             value="$interface$" />
					<PARAM name="collMdstoreId"         ref="collMdstoreId" />
					<PARAM name="cleanMdstoreId"        ref="cleanMdstoreId" />
					<PARAM name="patchMdstoreId"        ref="patchMdstoreId" />
					<PARAM name="nativeObjectStoreId"   ref="nativeObjectStoreId" />
					<PARAM name="indexId"               ref="indexId" />
				</PARAMETERS>
            </DESTROY_WORKFLOW_TEMPLATE>
        </CONFIGURATION>
        
        <NOTIFICATIONS/>
        
        <SCHEDULING enabled="false">
            <CRON>9 9 9 ? * *</CRON>
            <MININTERVAL>10080</MININTERVAL>
        </SCHEDULING>
        <STATUS/>
    </BODY>
</RESOURCE_PROFILE>
