<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:efg="http://www.europeanfilmgateway.eu/efg"
                version="2.0"
>

	<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="/">
		<xsl:variable name="id" select="//*[local-name() = 'objIdentifier']"/>
		<xsl:variable name="type" select="local-name(//*[local-name()='efgEntity']/*)"/>

		<div class="well">
			<table>
				<tr>
					<td style="width: 120px">
						<img src="../resources/img/record.png" width="80" height="80"/>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test=" $type = 'avcreation' ">
								<strong>Title:</strong>
								<xsl:value-of select="//efg:title[1]/efg:text"/>
								<br/>
							</xsl:when>
							<xsl:when test=" $type = 'nonavcreation' ">
								<strong>Title:</strong>
								<xsl:value-of select="//efg:title[1]/efg:text"/>
								<br/>
							</xsl:when>

							<xsl:when test="$type ='person'">
								<strong>Name:</strong>
								<xsl:for-each select="//efg:name">
									<xsl:value-of select="concat(.,' ')"/>
								</xsl:for-each>
								<br/>
							</xsl:when>

							<xsl:when test="$type ='corporate'">
								<strong>Name:</strong>
								<xsl:for-each select="//efg:name">
									<xsl:value-of select="concat(.,' ')"/>
								</xsl:for-each>
								<br/>
							</xsl:when>

						</xsl:choose>
						<strong>Type:</strong>
						<i>
							<xsl:value-of select="local-name(//*[local-name()='efgEntity']/*)"/>
						</i>
						<br/>
						<br/>
						<button class="btn btn-primary btn-sm" ng-click="getDocument('objidentifier', '{$id}')">show record</button>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>
</xsl:stylesheet>