package eu.dnetlib.efg.workflows.nodes.thumbnail;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.UUID;

import org.apache.tika.Tika;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;

/**
 * Created by sandro on 4/8/16.
 */
public class ThumbnailGenerator {

	private Path baseDirPath;

	private String dirName;

	public ThumbnailGenerator() throws IOException {
		dirName = UUID.randomUUID().toString();
		baseDirPath = Files.createTempDirectory(dirName);
	}

	public static boolean deleteRecursive(File path) throws FileNotFoundException {
		if (!path.exists()) throw new FileNotFoundException(path.getAbsolutePath());
		boolean ret = true;
		if (path.isDirectory()) {
			for (File f : path.listFiles()) {
				ret = ret && deleteRecursive(f);
			}
		}
		return ret && path.delete();
	}

	public InputStream convert(final InputStream input, int width, int height, final String name, boolean deleteBeforeConver) {
		try {
			destroyFolder();
			baseDirPath = Files.createTempDirectory(dirName);
			final Path tempFile = baseDirPath.resolve(name + "_orig");
			Files.copy(input, tempFile, StandardCopyOption.REPLACE_EXISTING);
			final String inputType = guessMimeType(tempFile.toAbsolutePath().toString());

			String inputPath = tempFile.toAbsolutePath().toString();
			if (inputType != null && inputType.contains("pdf")) {
				inputPath += "[0]";
			}
			ConvertCmd cmd = new ConvertCmd();
			IMOperation op = new IMOperation();
			op.addImage(inputPath);
			op.define(String.format("jpeg:size=%dx%d", width * 2, height * 2));
			op.thumbnail(width, height);
			op.unsharp(0.5);
			op.background("transparent");
			op.gravity("center");
			op.extent(width, height);
			op.colors(256);
			op.addImage(tempFile.toAbsolutePath().toString().replace("orig", "conv.png"));
			cmd.run(op);
			final Path path = FileSystems.getDefault().getPath(tempFile.toAbsolutePath().toString().replace("orig", "conv.png"));
			return Files.newInputStream(path);
		} catch (Throwable e) {
			System.out.println("Error on convert file" + e.toString());
			return null;
		}
	}

	private String guessMimeType(final String inputPath) throws IOException {
		Tika tika = new Tika();
		return tika.detect(new File(inputPath));
	}

	public boolean destroyFolder() throws FileNotFoundException {
		return deleteRecursive(baseDirPath.toFile());

	}

}
