/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.efg.download.plugin;

import com.google.gson.Gson;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.rmi.data.AbstractDownloadPlugin;
import eu.dnetlib.rmi.data.DownloadItem;
import eu.dnetlib.rmi.data.DownloadPlugin;
import eu.dnetlib.rmi.data.DownloadPluginException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EFGDownloadPlugin
extends AbstractDownloadPlugin
implements DownloadPlugin {
    private static final List<String> suffix = Arrays.asList("jpg", "jpeg", "gif", "png", "pdf", "ps", "djvu", "scanpix");

    public String extractURL(String baseURL) throws DownloadPluginException {
        if (baseURL == null) {
            return null;
        }
        for (String s : suffix) {
            if (!baseURL.trim().endsWith(s)) continue;
            return baseURL;
        }
        return null;
    }

    public void setBasePath(String basePath) {
    }

    public DownloadItem retrieveUrl(DownloadItem input) throws DownloadPluginException {
        try {
            String url = input.getOriginalUrl();
            if (url == null || url.trim().length() == 0) {
                return input;
            }
            List urls = (List)new Gson().fromJson(url, ArrayList.class);
            if (urls == null || urls.size() == 0) {
                input.setUrl(null);
                input.setOriginalUrl(null);
                return input;
            }
            if (this.checkUrlsNotNull(input, urls)) {
                return input;
            }
            input.setOriginalUrl(null);
            input.setUrl(null);
            return input;
        }
        catch (Throwable e) {
            throw new DownloadPluginException("error on retrieve correct Url");
        }
    }

    public Iterable<DownloadItem> retrieveUrls(Iterable<DownloadItem> items) throws DownloadPluginException {
        return DnetStreamSupport.generateStreamFromIterator(items.iterator()).map(it -> this.retrieveUrl((DownloadItem)it))::iterator;
    }

    public String getPluginName() {
        return "EFGDownloadPlugin";
    }
}

