<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:efg="http://www.europeanfilmgateway.eu/efg"
                xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:dcterms="http://purl.org/dc/terms/"
                xmlns:exslt="http://exslt.org/common" version="1.0"
                exclude-result-prefixes="xsl exslt">

	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyz'"/>
	<xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="count(//efg:efgEntity/efg:avcreation) &gt; 0 and (count(//efg:isShownBy) &gt; 0 or count(//efg:isShownAt) &gt; 0)">
				<oai:record xmlns:dri="http://www.driver-repository.eu/namespace/dri"
				            xmlns:oai="http://www.openarchives.org/OAI/2.0/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
					<oai:header>
						<dri:objIdentifier>
							<xsl:value-of select=".//dri:objIdentifier"/>
						</dri:objIdentifier>
						<dri:recordIdentifier>
							<xsl:value-of select=".//dri:recordIdentifier"/>
						</dri:recordIdentifier>
						<dri:repositoryId>
							<xsl:value-of select=".//dri:repositoryId"/>
						</dri:repositoryId>
						<dri:datasourceprefix>
							<xsl:value-of select=".//dri:datasourceprefix"/>
						</dri:datasourceprefix>
						<oai:identifier>
							<xsl:value-of select=".//oai:identifier"/>
						</oai:identifier>
					</oai:header>
					<oai:metadata>
						<xsl:apply-templates select=".//efg:efgEntity/efg:avcreation"/>
					</oai:metadata>
				</oai:record>
			</xsl:when>

			<xsl:when test="count(//efg:efgEntity/efg:nonavcreation) &gt; 0 and count(//efg:isShownBy) &gt; 0">
				<oai:record xmlns:dri="http://www.driver-repository.eu/namespace/dri"
				            xmlns:oai="http://www.openarchives.org/OAI/2.0/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
					<oai:header>
						<dri:objIdentifier>
							<xsl:value-of select=".//dri:objIdentifier"/>
						</dri:objIdentifier>
						<dri:recordIdentifier>
							<xsl:value-of select=".//dri:recordIdentifier"/>
						</dri:recordIdentifier>
						<dri:repositoryId>
							<xsl:value-of select=".//dri:repositoryId"/>
						</dri:repositoryId>
						<dri:datasourceprefix>
							<xsl:value-of select=".//dri:datasourceprefix"/>
						</dri:datasourceprefix>
						<oai:identifier>
							<xsl:value-of select=".//oai:identifier"/>
						</oai:identifier>
					</oai:header>
					<oai:metadata>
						<xsl:apply-templates select=".//efg:efgEntity/efg:nonavcreation"/>
					</oai:metadata>
				</oai:record>
			</xsl:when>
			<xsl:otherwise>
				<JUNK/>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<xsl:template match="identifier | dri:objIdentifier | dri:recordIdentifier" mode="header">
		<xsl:param name="pos"/>
		<xsl:copy>
			<xsl:value-of select="concat(text(), '-', $pos)"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="*" mode="header">
		<xsl:param name="pos"/>
		<xsl:copy-of select="."/>
	</xsl:template>


	<xsl:template match="efg:avcreation | efg:nonavcreation">

		<xsl:variable name="creationType" select="local-name(.)"/>

		<record>
			<header>
				<xsl:apply-templates select="/record/header/*" mode="header">
					<xsl:with-param name="pos">
						<xsl:value-of select="position()"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</header>
			<metadata>
				<rdf:RDF xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				         xmlns:dc="http://purl.org/dc/elements/1.1/"
				         xmlns:edm="http://www.europeana.eu/schemas/edm/"
				         xmlns:ore="http://www.openarchives.org/ore/terms/"
				         xmlns:dcterms="http://purl.org/dc/terms/"
				         xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
				         xsi:schemaLocation="http://www.w3.org/1999/02/22-rdf-syntax-ns# EDM-INTERNAL.xsd">

					<xsl:variable name="efg_provider" select="//efg:provider"/>


					<ore:Aggregation>
						<xsl:attribute name="rdf:about">
							<xsl:value-of select="./efg:recordSource/efg:sourceID"/>
						</xsl:attribute>

						<edm:aggregatedCHO>
							<xsl:attribute name="rdf:resource">
								<xsl:value-of select="./efg:recordSource/efg:sourceID"/>
							</xsl:attribute>
						</edm:aggregatedCHO>

						<xsl:for-each select="//efg:avManifestation">
							<xsl:variable name="status">
								<xsl:value-of
										select="translate(normalize-space(.//efg:digitalFormat/efg:status), $upper, $small)"
								/>
							</xsl:variable>

							<xsl:choose>
								<xsl:when test="$status != 'born digital'">
									<xsl:variable name="rightStatus">
										<xsl:value-of
												select="translate(normalize-space(.//efg:rightsStatus), $upper, $small)"
										/>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="$rightStatus = 'copyright protected'">
											<edm:rights>http://www.europeana.eu/rights/rr-f/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'not copyright protected'">
											<edm:rights>http://creativecommons.org/publicdomain/mark/1.0/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'public domain'">
											<edm:rights>http://creativecommons.org/publicdomain/mark/1.0/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'orphan'">
											<edm:rights>http://www.europeana.eu/rights/orphan-work-eu/</edm:rights>
										</xsl:when>
										<xsl:when
												test="$rightStatus = 'no known copyright / orphan work'">
											<edm:rights>http://www.europeana.eu/rights/orphan-work-eu/</edm:rights>
										</xsl:when>
										<xsl:otherwise>
											<edm:rights>http://www.europeana.eu/rights/rr-f/</edm:rights>
										</xsl:otherwise>
									</xsl:choose>

									<xsl:for-each select="//efg:rightsHolder">
										<dc:rights>
											<xsl:value-of select="."/>
										</dc:rights>
									</xsl:for-each>
									<!--
									<xsl:choose>
										<xsl:when test="string-length($rightStatus) &gt; 0">
											<edm:rights>
												<xsl:value-of select="$rightStatus"/>
											</edm:rights>
										</xsl:when>
									</xsl:choose>
									-->
									<xsl:for-each select="//efg:isShownBy">
										<edm:isShownBy>
											<xsl:value-of select="."/>
										</edm:isShownBy>
									</xsl:for-each>
									<xsl:for-each select="//efg:isShownAt">
										<edm:isShownAt>
											<xsl:value-of select="."/>
										</edm:isShownAt>
									</xsl:for-each>

									<xsl:choose>
										<xsl:when test="count(//efg:thumbnail) &gt; 0">
											<xsl:for-each select="//efg:thumbnail">
												<edm:object>
													<xsl:value-of select="."/>
												</edm:object>
											</xsl:for-each>
										</xsl:when>
										<xsl:otherwise>
											<xsl:for-each select="//efg:isShownBy">
												<edm:object>
													<xsl:value-of select="."/>
												</edm:object>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>


								</xsl:when>
							</xsl:choose>

						</xsl:for-each>

						<xsl:for-each select="//efg:nonAVManifestation">
							<xsl:variable name="status">
								<xsl:value-of
										select="translate(normalize-space(.//efg:digitalFormat/efg:status), $upper, $small)"
								/>
							</xsl:variable>

							<xsl:choose>
								<xsl:when test="$status != 'born digital'">
									<xsl:variable name="rightStatus">
										<xsl:value-of
												select="translate(normalize-space(.//efg:rightsStatus), $upper, $small)"
										/>
									</xsl:variable>


									<xsl:variable name="rightStatus">
										<xsl:value-of
												select="translate(normalize-space(.//efg:rightsStatus), $upper, $small)"
										/>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="$rightStatus = 'copyright protected'">
											<edm:rights>http://www.europeana.eu/rights/rr-f/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'not copyright protected'">
											<edm:rights>http://creativecommons.org/publicdomain/mark/1.0/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'public domain'">
											<edm:rights>http://creativecommons.org/publicdomain/mark/1.0/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'orphan'">
											<edm:rights>http://www.europeana.eu/rights/orphan-work-eu/</edm:rights>
										</xsl:when>
										<xsl:when
												test="$rightStatus = 'no known copyright / orphan work'">
											<edm:rights>http://www.europeana.eu/rights/orphan-work-eu/</edm:rights>
										</xsl:when>
										<xsl:otherwise>
											<edm:rights>http://www.europeana.eu/rights/rr-f/</edm:rights>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:for-each select="//efg:isShownBy">
										<edm:isShownBy>
											<xsl:value-of select="."/>
										</edm:isShownBy>
									</xsl:for-each>
									<xsl:for-each select="//efg:isShownAt">
										<edm:isShownAt>
											<xsl:value-of select="."/>
										</edm:isShownAt>
									</xsl:for-each>
									<xsl:for-each select="//efg:rightsHolder">
										<dc:rights>
											<xsl:value-of select="."/>
										</dc:rights>
									</xsl:for-each>

									<xsl:choose>
										<xsl:when test="count(//efg:thumbnail) &gt; 0">
											<xsl:for-each select="//efg:thumbnail">
												<edm:object>
													<xsl:value-of select="."/>
												</edm:object>
											</xsl:for-each>
										</xsl:when>
										<xsl:otherwise>
											<xsl:for-each select="//efg:isShownBy">
												<edm:object>
													<xsl:value-of select="."/>
												</edm:object>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>


								</xsl:when>
							</xsl:choose>

						</xsl:for-each>


						<edm:dataProvider>
							<xsl:value-of select="$efg_provider"/>
						</edm:dataProvider>
						<edm:provider>EFG - The European Film Gateway</edm:provider>

					</ore:Aggregation>


					<edm:ProvidedCHO>
						<xsl:attribute name="rdf:about">
							<xsl:value-of select="//efg:recordSource[1]/efg:sourceID"/>
						</xsl:attribute>
						<xsl:for-each select="//efg:avcreation/efg:recordSource/efg:sourceID">
							<dc:identifier>
								<xsl:value-of select="."/>
							</dc:identifier>
						</xsl:for-each>

						<xsl:for-each select="//efg:nonavcreation/efg:recordSource/efg:sourceID">
							<dc:identifier>
								<xsl:value-of select="."/>
							</dc:identifier>
						</xsl:for-each>
						<xsl:for-each select="//efg:language">
							<dc:language>
								<xsl:value-of select="translate(normalize-space(.), $upper, $small)"/>
							</dc:language>
						</xsl:for-each>

						<xsl:for-each select="//efg:avcreation//efg:relPerson">
							<xsl:variable name="person_type"
							              select="translate(normalize-space(./efg:type), $upper, $small)"/>
							<xsl:choose>
								<xsl:when
										test="$person_type = 'director of photography' or $person_type = 'screenplay' or $person_type = 'editor' or $person_type = 'music composer'">
									<dc:contributor>
										<xsl:value-of select="./efg:name"/>
									</dc:contributor>
								</xsl:when>
								<xsl:when test="$person_type = 'director'">
									<dc:creator>
										<xsl:value-of select="./efg:name"/>
									</dc:creator>
								</xsl:when>
								<xsl:when
										test="
										$person_type = 'publisher' or $person_type = 'creator' or $person_type = 'designer' or $person_type = 'photographer'
										or $person_type = 'lithographer' or $person_type = 'book designer' or $person_type = 'author'
										or $person_type = 'lyrics' or $person_type = 'composer' or $person_type = 'illustrator' or $person_type = 'artist'
										or $person_type = 'manufacturer' or $person_type = 'attributed to' or $person_type = 'stills photographer'">
									<dc:creator>
										<xsl:value-of select="./efg:name"/>
									</dc:creator>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>


						<xsl:for-each select="//efg:nonavcreation//efg:relPerson">
							<xsl:variable name="person_type"
							              select="translate(normalize-space(./efg:type), $upper, $small)"/>
							<xsl:choose>
								<xsl:when
										test="
									$person_type = 'creator' or $person_type = 'designer' or $person_type = 'photographer'
									or $person_type = 'lithographer' or $person_type = 'book designer' or $person_type = 'author'
									or $person_type = 'lyrics' or $person_type = 'composer' or $person_type = 'illustrator' or $person_type = 'artist'
									or $person_type = 'manufacturer' or $person_type = 'attributed to' or $person_type = 'stills photographer'">
									<dc:creator>
										<xsl:value-of select="./efg:name"/>
									</dc:creator>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>


						<xsl:for-each select="//efg:relCorporate">
							<xsl:variable name="corporate_type"
							              select="translate(normalize-space(./efg:type), $upper, $small)"/>
							<xsl:choose>
								<xsl:when test="$corporate_type = 'production company'">
									<dc:contributor>
										<xsl:value-of select="./efg:name"/>
									</dc:contributor>
								</xsl:when>
								<xsl:when test="$corporate_type = 'publisher'">
									<dc:publisher>
										<xsl:value-of select="./efg:name"/>
									</dc:publisher>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>

						<xsl:for-each select="//efg:description">
							<dc:description>
								<xsl:attribute name="xml:lang">
									<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
								</xsl:attribute>
								<xsl:value-of select="."/>
							</dc:description>
						</xsl:for-each>
						<xsl:for-each select="//efg:DigitalFormat">
							<xsl:choose>
								<xsl:when test="./Status = 'Born digital'">
									<xsl:for-each select="./efg:Container">
										<dc:format>
											<xsl:value-of select="."/>
										</dc:format>
									</xsl:for-each>

								</xsl:when>
							</xsl:choose>

						</xsl:for-each>


						<xsl:for-each select="//efg:avcreation//efg:keywords">
							<xsl:variable name="keyword_type"
							              select="translate(normalize-space(./@type), $upper, $small)"/>
							<xsl:choose>
								<xsl:when
										test="$keyword_type = 'genre' or $keyword_type = 'lcsh' or $keyword_type = 'person' or $keyword_type = 'subject' or $keyword_type = 'place' or $keyword_type = 'project' or $keyword_type = 'n/a'">
									<dcterms:subject>
										<xsl:attribute name="xml:lang">
											<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
										</xsl:attribute>
										<xsl:value-of select="./efg:term"/>
									</dcterms:subject>
								</xsl:when>

								<xsl:when test="$keyword_type = 'form'">
									<dc:type>
										<xsl:attribute name="xml:lang">
											<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
										</xsl:attribute>
										<xsl:value-of select="./efg:term"/>
									</dc:type>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>
						<xsl:for-each select="//efg:nonavcreation//efg:keywords">
							<dcterms:subject>
								<xsl:attribute name="xml:lang">
									<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
								</xsl:attribute>
								<xsl:value-of select="./efg:term"/>
							</dcterms:subject>
						</xsl:for-each>


						<xsl:choose>
							<xsl:when test="count(//efg:avManifestation//efg:title) &gt; 0">
								<xsl:for-each select="//efg:avManifestation//efg:title">
									<xsl:variable name="title_rel"
									              select="translate(normalize-space(./efg:relation), $upper, $small)"/>
									<xsl:choose>
										<xsl:when test="$title_rel = 'original title'">
											<dc:title>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dc:title>
										</xsl:when>
										<xsl:when test="$title_rel = 'main title'">
											<dc:title>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dc:title>
										</xsl:when>
										<xsl:otherwise>
											<dcterms:alternative>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dcterms:alternative>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<xsl:for-each select="//efg:avcreation//efg:title">
									<xsl:variable name="title_rel"
									              select="translate(normalize-space(./efg:relation), $upper, $small)"/>
									<xsl:choose>
										<xsl:when test="$title_rel = 'original title'">
											<dc:title>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dc:title>
										</xsl:when>
										<xsl:when test="$title_rel = 'main title'">
											<dc:title>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dc:title>
										</xsl:when>
										<xsl:otherwise>
											<dcterms:alternative>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dcterms:alternative>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>

						<xsl:choose>
							<xsl:when test="count(//efg:nonAVManifestation//efg:title) &gt; 0">

								<xsl:for-each select="//efg:nonAVManifestation//efg:title">
									<xsl:variable name="title_rel"
									              select="translate(normalize-space(./efg:relation), $upper, $small)"/>
									<xsl:choose>
										<xsl:when test="$title_rel = 'original title'">
											<dc:title>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dc:title>
										</xsl:when>
										<xsl:when test="$title_rel = 'main title'">
											<dc:title>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dc:title>
										</xsl:when>
										<xsl:otherwise>
											<dcterms:alternative>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dcterms:alternative>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>

								<xsl:for-each select="//efg:nonavcreation//efg:title">
									<xsl:variable name="title_rel"
									              select="translate(normalize-space(./efg:relation), $upper, $small)"/>
									<xsl:choose>
										<xsl:when test="$title_rel = 'original title'">
											<dc:title>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dc:title>
										</xsl:when>
										<xsl:when test="$title_rel = 'main title'">
											<dc:title>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dc:title>
										</xsl:when>
										<xsl:otherwise>
											<dcterms:alternative>
												<xsl:attribute name="xml:lang">
													<xsl:value-of select="translate(normalize-space(./@lang), $upper, $small)"/>
												</xsl:attribute>
												<xsl:value-of select="./efg:text"/>
											</dcterms:alternative>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>

							</xsl:otherwise>
						</xsl:choose>


						<xsl:for-each select="//efg:specificType">
							<xsl:choose>
								<xsl:when
										test="count(normalize-space(.)) &gt; 0 and normalize-space(.) != 'n/a'">
									<dc:type>
										<xsl:value-of select="."/>
									</dc:type>
								</xsl:when>
								<xsl:otherwise>
									<dc:type>
										<xsl:value-of
												select="//efg:avManifestation/efg:item/efg:type"/>
									</dc:type>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>

						<xsl:for-each select="//efg:productionYear">
							<dcterms:created>
								<xsl:value-of select="."/>
							</dcterms:created>
						</xsl:for-each>

						<xsl:for-each select="//efg:nonAVManifestation/efg:dateCreated">
							<dcterms:created>
								<xsl:value-of select="."/>
							</dcterms:created>
						</xsl:for-each>
						<xsl:for-each select="//efg:physicalFormat">
							<dc:format>
								<xsl:value-of select="./@size"/>
							</dc:format>
						</xsl:for-each>
						<xsl:for-each
								select="//efg:nonAVManifestation/efg:date[./efg:type = 'issued']">
							<dcterms:issued>
								<xsl:value-of select="."/>
							</dcterms:issued>
						</xsl:for-each>
						<xsl:for-each select="//efg:coverage/efg:spatial">
							<dcterms:spatial>
								<xsl:value-of select="translate(normalize-space(.), $small, $upper)"/>
							</dcterms:spatial>
						</xsl:for-each>

						<xsl:for-each select="//efg:nonAVManifestation/efg:geographicScope/efg:place">
							<dcterms:spatial>
								<xsl:value-of select="translate(normalize-space(.), $small, $upper)"/>
							</dcterms:spatial>
						</xsl:for-each>
						<xsl:for-each select="//efg:countryOfReference">
							<dcterms:spatial>
								<xsl:value-of select="translate(normalize-space(.), $small, $upper)"/>
							</dcterms:spatial>
						</xsl:for-each>
						<xsl:for-each select="//efg:coverage/efg:temporal">
							<dcterms:temporal>
								<xsl:value-of select="."/>
							</dcterms:temporal>
						</xsl:for-each>
						<xsl:for-each select="//efg:item/efg:type">
							<edm:type>
								<xsl:value-of select="translate(normalize-space(.), $small, $upper)"/>
							</edm:type>
						</xsl:for-each>
						<xsl:for-each select="//efg:avManifestation//efg:provenance">
							<dcterms:provenance>
								<xsl:value-of select="."/>
							</dcterms:provenance>
						</xsl:for-each>
					</edm:ProvidedCHO>


					<xsl:for-each select="//efg:avManifestation">
						<xsl:variable name="status">
							<xsl:value-of
									select="translate(normalize-space(.//efg:digitalFormat/efg:status), $upper, $small)"
							/>
						</xsl:variable>


						<xsl:choose>
							<xsl:when test="$status != 'born digital' and count(//efg:isShownBy) &gt; 0 ">
								<edm:WebResource>
									<xsl:attribute name="rdf:about">
										<xsl:value-of select=".//efg:isShownBy"/>
									</xsl:attribute>
									<xsl:choose>
										<xsl:when test="string-length(normalize-space($status)) &gt; 0">
											<dc:format>
												<xsl:value-of select="$status"/>
											</dc:format>
										</xsl:when>
									</xsl:choose>
									<xsl:for-each select=".//efg:duration">
										<dcterms:extent>
											<xsl:value-of select="."/>
										</dcterms:extent>
									</xsl:for-each>
									<xsl:variable name="rightStatus">
										<xsl:value-of
												select="translate(normalize-space(.//efg:rightsStatus), $upper, $small)"
										/>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="$rightStatus = 'copyright protected'">
											<edm:rights>http://www.europeana.eu/rights/rr-f/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'not copyright protected'">
											<edm:rights>http://creativecommons.org/publicdomain/mark/1.0/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'public domain'">
											<edm:rights>http://creativecommons.org/publicdomain/mark/1.0/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'orphan'">
											<edm:rights>http://www.europeana.eu/rights/orphan-work-eu/</edm:rights>
										</xsl:when>
										<xsl:when
												test="$rightStatus = 'no known copyright / orphan work'">
											<edm:rights>http://www.europeana.eu/rights/orphan-work-eu/</edm:rights>
										</xsl:when>
										<xsl:otherwise>
											<edm:rights>http://www.europeana.eu/rights/rr-f/</edm:rights>
										</xsl:otherwise>
									</xsl:choose>
								</edm:WebResource>
							</xsl:when>
						</xsl:choose>

					</xsl:for-each>


					<xsl:for-each select="//efg:nonAVManifestation">
						<xsl:variable name="status">
							<xsl:value-of
									select="translate(normalize-space(.//efg:digitalFormat/efg:status), $upper, $small)"
							/>
						</xsl:variable>

						<xsl:choose>
							<xsl:when test="$status != 'born digital' and count(//efg:isShownBy) &gt; 0">
								<edm:WebResource>
									<xsl:attribute name="rdf:about">
										<xsl:value-of select=".//efg:isShownBy"/>
									</xsl:attribute>
									<xsl:choose>
										<xsl:when test="string-length(normalize-space($status)) &gt; 0">
											<dc:format>
												<xsl:value-of select="$status"/>
											</dc:format>
										</xsl:when>
									</xsl:choose>

									<xsl:for-each select=".//efg:duration">
										<dcterms:extent>
											<xsl:value-of select="."/>
										</dcterms:extent>
									</xsl:for-each>
									<xsl:variable name="rightStatus">
										<xsl:value-of select="translate(normalize-space(.//efg:rightsStatus), $upper, $small)"
										/>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="$rightStatus = 'copyright protected'">
											<edm:rights>http://www.europeana.eu/rights/rr-f/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'not copyright protected'">
											<edm:rights>http://creativecommons.org/publicdomain/mark/1.0/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'public domain'">
											<edm:rights>http://creativecommons.org/publicdomain/mark/1.0/</edm:rights>
										</xsl:when>
										<xsl:when test="$rightStatus = 'orphan'">
											<edm:rights>http://www.europeana.eu/rights/orphan-work-eu/</edm:rights>
										</xsl:when>
										<xsl:when
												test="$rightStatus = 'no known copyright / orphan work'">
											<edm:rights>http://www.europeana.eu/rights/orphan-work-eu/</edm:rights>
										</xsl:when>
										<xsl:otherwise>
											<edm:rights>http://www.europeana.eu/rights/rr-f/</edm:rights>
										</xsl:otherwise>
									</xsl:choose>
								</edm:WebResource>
							</xsl:when>
						</xsl:choose>


					</xsl:for-each>
				</rdf:RDF>
			</metadata>
		</record>
	</xsl:template>


	<xsl:template name="distinct">
		<xsl:param name="var"/>

		<xsl:variable name="svar">
			<xsl:for-each select="exslt:node-set($var)/*">
				<xsl:sort select="."/>
				<xsl:copy-of select="."/>
			</xsl:for-each>
		</xsl:variable>

		<xsl:for-each select="exslt:node-set($svar)/*">
			<xsl:variable name="pos" select="position()"/>
			<xsl:if test="string(../child::*[$pos - 1]) != string(.)">
				<xsl:copy-of select="."/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>


</xsl:stylesheet>