package eu.dnetlib.efg.workflows.nodes;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.MDStoreService;

/**
 * Created by sandro on 2/22/16.
 */
public class ExecuteMDStorePluginJobNode extends BlackboardJobNode {

	private String mdStoreId;

	private String pluginName;

	public String getPluginName() {
		return this.pluginName;
	}

	public void setPluginName(final String pluginName) {
		this.pluginName = pluginName;
	}

	public String getMdStoreId() {
		return this.mdStoreId;
	}

	public void setMdStoreId(final String mdStoreId) {
		this.mdStoreId = mdStoreId;
	}

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(MDStoreService.class, getMdStoreId());
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {

		job.setAction("RUN_PLUGIN");
		job.getParameters().put("plugin.name", getPluginName());
		job.getParameters().put("mdStoreId", getMdStoreId());

	}
}
