/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.efg.thumbnails;

import eu.dnetlib.data.objectstore.gridFS.GridFSObjectStore;
import eu.dnetlib.data.objectstore.gridFS.GridFSObjectstoreDaoImpl;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ThumbnailController {
    @Autowired
    UniqueServiceLocator serviceLocator;
    @Autowired
    GridFSObjectstoreDaoImpl objectstoreDao;
    private Map<String, String> objectStoresThumbnail;

    @RequestMapping(value={"/thumbnail/objectStoresThumbnail"})
    @ResponseBody
    public Map<String, String> getObjectStoresThumbnail(ModelMap map) throws Exception {
        if (this.objectStoresThumbnail == null) {
            this.createObjectStoreThumbnail();
        }
        return this.objectStoresThumbnail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/thumbnail/getThumbnail/{type}/{size}/{metadataId}"}, method={RequestMethod.GET})
    public void getThumbnail(HttpServletResponse response, @PathVariable String metadataId, @PathVariable int size, @PathVariable String type) throws Exception {
        if (size != 96 && size != 250) {
            throw new Exception("Image size not supported!");
        }
        InputStream inputStream = null;
        if (!(type.equalsIgnoreCase("video") || type.equalsIgnoreCase("image") || type.equalsIgnoreCase("text"))) {
            type = "video";
        }
        if (this.objectStoresThumbnail == null) {
            this.createObjectStoreThumbnail();
        }
        if (this.objectStoresThumbnail.size() == 0) {
            inputStream = this.getClass().getResourceAsStream(String.format("/eu/dnetlib/thumbnail/NF%s_%d.jpg", type.toLowerCase(), size));
        } else {
            GridFSObjectStore objectStore = (GridFSObjectStore)this.objectstoreDao.getObjectStore(this.objectStoresThumbnail.get(String.format("thumb%d", size == 250 ? 256 : size)));
            ObjectStoreFile objectStoreFile = objectStore.deliverObjectFromMetadataIdentifier(metadataId);
            inputStream = objectStoreFile == null ? this.getClass().getResourceAsStream(String.format("/eu/dnetlib/thumbnail/NF%s_%d.jpg", type.toLowerCase(), size)) : objectStore.deliverStream(objectStoreFile.getObjectID());
        }
        if (inputStream != null) {
            try {
                ServletOutputStream outputStream = response.getOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                inputStream.close();
            }
        }
    }

    private void createObjectStoreThumbnail() throws Exception {
        String query = "for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType')\nwhere  $x//OBJECTSTORE_INTERPRETATION = 'thumb96' or $x//OBJECTSTORE_INTERPRETATION = 'thumb256' \n return concat($x//OBJECTSTORE_INTERPRETATION, '<-->',   $x//RESOURCE_IDENTIFIER/@value/string())";
        ISLookUpService lookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        List queryResult = lookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType')\nwhere  $x//OBJECTSTORE_INTERPRETATION = 'thumb96' or $x//OBJECTSTORE_INTERPRETATION = 'thumb256' \n return concat($x//OBJECTSTORE_INTERPRETATION, '<-->',   $x//RESOURCE_IDENTIFIER/@value/string())");
        if (queryResult == null) {
            throw new Exception("Missing objectStore Thumbnail");
        }
        this.objectStoresThumbnail = new HashMap<String, String>();
        queryResult.stream().forEach(item -> {
            String[] splitString = item.split("<-->");
            if (splitString == null || splitString.length != 2) {
                throw new RuntimeException("Error wrong splitting");
            }
            this.objectStoresThumbnail.put(splitString[0], splitString[1]);
        });
    }
}

