<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:efg="http://www.europeanfilmgateway.eu/efg"
                version="2.0"
>

	<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="/">
		<xsl:variable name="recordId"   select="//*[local-name() = 'objIdentifier']" />
		<xsl:variable name="type" select="local-name(//*[local-name()='efgEntity']/*)"/>
		
		<xsl:if test="$type = 'avcreation' or $type = 'avManifestation' or $type = 'nonavcreation' or $type = 'nonAVManifestation'">
			<div class="row">
				<div class="col-xs-12">
					<a class="btn btn-default btn-sm pull-right" href="../ui/patcheditor.do#patch/{$recordId}" >
						<span class="glyphicon glyphicon glyphicon-chevron-left"></span> patch
					</a>
				</div>
			</div>
		</xsl:if>
						
		<div class="row">
			<div class="col-xs-2">
				<img src="../resources/img/record.png" width="80" height="80"/>
			</div>
			<div class="col-xs-10">

				<xsl:choose>
					<xsl:when test=" $type = 'avcreation' or $type = 'nonavcreation' ">
						<h1 id="overview">
							<xsl:value-of select="//efg:title[1]/efg:text"/>
						</h1>
					</xsl:when>

					<xsl:when test="$type ='person' or $type ='corporate' or $type ='group' ">
						<h1 id="overview">
							<xsl:for-each select="//efg:name">
								<xsl:value-of select="concat(.,' ')"/>
							</xsl:for-each>
						</h1>
					</xsl:when>


				</xsl:choose>


				<xsl:if test="//*[local-name()='title']">

				</xsl:if>
			</div>
		</div>

		

		<div class="row">
			<div class="col-xs-12">
				<h6>
	
				
					<span class="glyphicon glyphicon-align-left"/>
					GENERAL INFORMATION
				</h6>
				<table class="table">
					<tbody>
						<tr>
							<td class="col-xs-3">
								<strong>Identifier</strong>
							</td>
							<td>
								<xsl:for-each select="//efg:sourceID">
									-
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Genre</strong>
							</td>
							<td>
								<xsl:for-each select="//efg:keywords[@type='genre']/efg:term">
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Synopsis</strong>
							</td>
							<td>
                                <xsl:for-each select="//efg:description[@type='Synopsis']">
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Subjects</strong>
							</td>
							<td>
								<xsl:for-each select="//efg:keywords[@type='Subject']/efg:term">
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Type</strong>
							</td>
							<td>
								<xsl:for-each select="local-name(//efg:efgEntity/*)">
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Archive</strong>
							</td>
							<td>
								<xsl:for-each select="//efg:provider">
									<xsl:if test="position()=1">
										<xsl:value-of select="."/>
									</xsl:if>
								</xsl:for-each>
								<br/>

							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Comment</strong>
							</td>
							<td>
								<xsl:for-each select="//efg:description[@type='comment']">
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Manifestation</strong>
							</td>
							<td>

								<xsl:for-each select="//efg:language">
									<i>Language:</i>
									<b>
										<xsl:value-of select="."/>
									</b>
									<br/>
								</xsl:for-each>
								<xsl:for-each select="//efg:duration">
									<i>Duration:</i>
									<b>
										<xsl:value-of select="."/>
									</b>
									<br/>
								</xsl:for-each>

							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>

		<xsl:for-each select="//*[local-name()='efgEntity']">
			<h6>
				<span class="glyphicon glyphicon-wrench"/>
				RECORD XML
			</h6>
			<xsl:call-template name="xmlItem">
				<xsl:with-param name="indent" select="string('')"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>


	<xsl:template name="xmlAttr">
		<span style='color:red'>
			<xsl:value-of select="concat(' ', local-name())"/>
		</span>
		<xsl:value-of select="concat('=&quot;', ., '&quot;')"/>
	</xsl:template>

	<xsl:template name="xmlItem">
		<xsl:param name="indent"/>
		<xsl:variable name="tag" select="local-name()"/>
		<xsl:variable name="newindent"><xsl:value-of select="$indent"/>&#160;&#160;&#160;&#160;
		</xsl:variable>

		<xsl:if test="string-length($tag)">
			<br/>
			<xsl:value-of select="$indent"/>
			<span style='color:blue'>
				<xsl:value-of select="concat('&lt;',$tag)"/>
			</span>
			<xsl:for-each select="@*">
				<xsl:call-template name="xmlAttr"/>
			</xsl:for-each>

			<xsl:choose>
				<xsl:when test="count(child::*) = 0 and count(child::text()) = 1">
					<span style='color:blue'>&gt;</span>
					<xsl:value-of select="normalize-space(.)"/>
					<span style='color:blue'>
						<xsl:value-of select="concat('&lt;/',$tag,'&gt;')"/>
					</span>
				</xsl:when>
				<xsl:when test="count(child::* | child::text()) &gt; 0">
					<span style='color:blue'>&gt;</span>
					<xsl:for-each select="child::* | child::text()">
						<xsl:choose>
							<xsl:when test="self::text() and string-length(normalize-space(.)) &gt; 0">
								<xsl:value-of select="normalize-space(.)"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="xmlItem">
									<xsl:with-param name="indent" select="$newindent"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					<br/>
					<xsl:value-of select="$indent"/>
					<span style='color:blue'>
						<xsl:value-of select="concat('&lt;/',$tag,'&gt;')"/>
					</span>
				</xsl:when>
				<xsl:otherwise>
					<span style='color:blue'>&#160;/&gt;</span>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>


</xsl:stylesheet>
