package eu.dnetlib.efg.download.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.google.gson.Gson;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.rmi.data.AbstractDownloadPlugin;
import eu.dnetlib.rmi.data.DownloadItem;
import eu.dnetlib.rmi.data.DownloadPlugin;
import eu.dnetlib.rmi.data.DownloadPluginException;

public class EFGDownloadPlugin extends AbstractDownloadPlugin implements DownloadPlugin {

	private final static List<String> suffix = Arrays.asList("jpg", "jpeg", "gif", "png", "pdf", "ps", "djvu", "scanpix");

	@Override
	public String extractURL(final String baseURL) throws DownloadPluginException {
		if (baseURL == null)
			return null;
		List<String> collect = suffix.stream().filter(s -> baseURL.toLowerCase().trim().endsWith(s)).collect(Collectors.toList());
		if (collect.size() > 0)
			return baseURL;
		return null;
	}

	@Override
	public void setBasePath(final String basePath) {

	}

	@Override
	public DownloadItem retrieveUrl(final DownloadItem input) throws DownloadPluginException {
		try {
			String url = input.getOriginalUrl();
			if (url == null || url.trim().length() == 0) {
				return input;
			}
			List<String> urls = new Gson().fromJson(url, ArrayList.class);
			if (urls == null || urls.size() == 0) {
				input.setUrl(null);
				input.setOriginalUrl(null);
				return input;
			}
			if (checkUrlsNotNull(input, urls))
				return input;
			input.setOriginalUrl(null);
			input.setUrl(null);
			return input;
		} catch (Throwable e) {
			throw new DownloadPluginException("error on retrieve correct Url");
		}
	}

	@Override
	public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> items) throws DownloadPluginException {
		return DnetStreamSupport.generateStreamFromIterator(items.iterator()).map(it -> retrieveUrl(it))::iterator;
	}

	@Override
	public String getPluginName() {
		return "EFGDownloadPlugin";
	}
}
