/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.index;

import com.google.common.base.Function;
import eu.dnetlib.data.index.CloudIndexClientException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;

public class CloudIndexClient {
    private static final Log log = LogFactory.getLog(CloudIndexClient.class);
    private static final String INDEX_RECORD_RESULT_FIELD = "dnetResult";
    private final CloudSolrServer solrServer;

    protected CloudIndexClient(CloudSolrServer solrServer) {
        this.solrServer = solrServer;
    }

    public int feed(String record, String indexDsId, Function<String, String> toIndexRecord) throws CloudIndexClientException {
        try {
            SolrInputDocument doc = this.prepareSolrDocument(record, indexDsId, toIndexRecord);
            if (doc == null || doc.isEmpty()) {
                throw new CloudIndexClientException("Invalid solr document");
            }
            return this.feed(doc);
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error feeding document", e);
        }
    }

    public int feed(SolrInputDocument document) throws CloudIndexClientException {
        try {
            UpdateResponse res = this.solrServer.add(document);
            if (res.getStatus() != 0) {
                throw new CloudIndexClientException("bad status: " + res.getStatus());
            }
            this.solrServer.commit();
            return res.getStatus();
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error feeding document", e);
        }
    }

    public void feed(List<SolrInputDocument> docs, AfterFeedingCallback callback) throws CloudIndexClientException {
        try {
            UpdateResponse res = this.solrServer.add(docs);
            this.solrServer.commit();
            if (callback != null) {
                callback.doAfterFeeding(res);
            }
            if (res.getStatus() != 0) {
                throw new CloudIndexClientException("bad status: " + res.getStatus());
            }
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error feeding documents", e);
        }
    }

    public SolrInputDocument prepareSolrDocument(String record, String indexDsId, Function<String, String> toIndexRecord) throws CloudIndexClientException {
        try {
            return null;
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error creating solr document", e);
        }
    }

    public boolean isRecordIndexed(String id) throws CloudIndexClientException {
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery("objidentifier:\"" + id + "\"");
            QueryResponse res = this.solrServer.query((SolrParams)query);
            return res.getResults().size() > 0;
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error searching documents", e);
        }
    }

    public void close() {
        if (this.solrServer != null) {
            this.solrServer.shutdown();
        }
    }

    public static interface AfterFeedingCallback {
        public void doAfterFeeding(UpdateResponse var1);
    }
}

