/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Element {
    private String text;
    private Map<String, String> attributes;

    public Element(String text, Map<String, String> attributes) {
        this.text = text;
        this.attributes = attributes;
    }

    public Element(String text) {
        this.text = text;
        this.attributes = Maps.newHashMap();
    }

    public Element() {
        this.text = "";
        this.attributes = Maps.newHashMap();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean isEmpty() {
        return !this.hasText() && !this.hasAttributes();
    }

    private boolean hasAttributes() {
        return this.getAttributes() != null && !this.getAttributes().isEmpty();
    }

    public boolean hasText() {
        return this.getText() != null && !this.getText().isEmpty();
    }

    public String toString() {
        return "{ " + StringUtils.left((String)this.text, (int)20) + this.attributes.toString() + " }";
    }
}

